package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.CollectionPeriodMs
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TimeBasedCollectionScheme(periodMs: CollectionPeriodMs) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.TimeBasedCollectionScheme = {
    import TimeBasedCollectionScheme.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.TimeBasedCollectionScheme
      .builder()
      .periodMs(CollectionPeriodMs.unwrap(periodMs): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.TimeBasedCollectionScheme.ReadOnly =
    zio.aws.iotfleetwise.model.TimeBasedCollectionScheme.wrap(buildAwsValue())
}
object TimeBasedCollectionScheme {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.TimeBasedCollectionScheme
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.TimeBasedCollectionScheme =
      zio.aws.iotfleetwise.model.TimeBasedCollectionScheme(periodMs)
    def periodMs: CollectionPeriodMs
    def getPeriodMs: ZIO[Any, Nothing, CollectionPeriodMs] =
      ZIO.succeed(periodMs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.TimeBasedCollectionScheme
  ) extends zio.aws.iotfleetwise.model.TimeBasedCollectionScheme.ReadOnly {
    override val periodMs: CollectionPeriodMs =
      zio.aws.iotfleetwise.model.primitives.CollectionPeriodMs(impl.periodMs())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.TimeBasedCollectionScheme
  ): zio.aws.iotfleetwise.model.TimeBasedCollectionScheme.ReadOnly =
    new Wrapper(impl)
}
