package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{
  TimestreamTableName,
  TimestreamDatabaseName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TimestreamResources(
    timestreamDatabaseName: TimestreamDatabaseName,
    timestreamTableName: TimestreamTableName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.TimestreamResources = {
    import TimestreamResources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.TimestreamResources
      .builder()
      .timestreamDatabaseName(
        TimestreamDatabaseName.unwrap(timestreamDatabaseName): java.lang.String
      )
      .timestreamTableName(
        TimestreamTableName.unwrap(timestreamTableName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.TimestreamResources.ReadOnly =
    zio.aws.iotfleetwise.model.TimestreamResources.wrap(buildAwsValue())
}
object TimestreamResources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.TimestreamResources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.TimestreamResources =
      zio.aws.iotfleetwise.model
        .TimestreamResources(timestreamDatabaseName, timestreamTableName)
    def timestreamDatabaseName: TimestreamDatabaseName
    def timestreamTableName: TimestreamTableName
    def getTimestreamDatabaseName: ZIO[Any, Nothing, TimestreamDatabaseName] =
      ZIO.succeed(timestreamDatabaseName)
    def getTimestreamTableName: ZIO[Any, Nothing, TimestreamTableName] =
      ZIO.succeed(timestreamTableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.TimestreamResources
  ) extends zio.aws.iotfleetwise.model.TimestreamResources.ReadOnly {
    override val timestreamDatabaseName: TimestreamDatabaseName =
      zio.aws.iotfleetwise.model.primitives
        .TimestreamDatabaseName(impl.timestreamDatabaseName())
    override val timestreamTableName: TimestreamTableName =
      zio.aws.iotfleetwise.model.primitives
        .TimestreamTableName(impl.timestreamTableName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.TimestreamResources
  ): zio.aws.iotfleetwise.model.TimestreamResources.ReadOnly = new Wrapper(impl)
}
