package zio.aws.iotfleetwise.model
import scala.jdk.CollectionConverters.*
sealed trait TriggerMode {
  def unwrap: software.amazon.awssdk.services.iotfleetwise.model.TriggerMode
}
object TriggerMode {
  def wrap(
      value: software.amazon.awssdk.services.iotfleetwise.model.TriggerMode
  ): zio.aws.iotfleetwise.model.TriggerMode = value match {
    case software.amazon.awssdk.services.iotfleetwise.model.TriggerMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleetwise.model.TriggerMode.ALWAYS =>
      val r = ALWAYS
      r
    case software.amazon.awssdk.services.iotfleetwise.model.TriggerMode.RISING_EDGE =>
      val r = RISING_EDGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotfleetwise.model.TriggerMode {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.TriggerMode =
      software.amazon.awssdk.services.iotfleetwise.model.TriggerMode.UNKNOWN_TO_SDK_VERSION
  }
  case object ALWAYS extends zio.aws.iotfleetwise.model.TriggerMode {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.TriggerMode =
      software.amazon.awssdk.services.iotfleetwise.model.TriggerMode.ALWAYS
  }
  case object RISING_EDGE extends zio.aws.iotfleetwise.model.TriggerMode {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.TriggerMode =
      software.amazon.awssdk.services.iotfleetwise.model.TriggerMode.RISING_EDGE
  }
}
