package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Description, FleetId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFleetRequest(
    fleetId: FleetId,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetRequest = {
    import UpdateFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetRequest
      .builder()
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.UpdateFleetRequest.ReadOnly =
    zio.aws.iotfleetwise.model.UpdateFleetRequest.wrap(buildAwsValue())
}
object UpdateFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.UpdateFleetRequest =
      zio.aws.iotfleetwise.model
        .UpdateFleetRequest(fleetId, description.map(value => value))
    def fleetId: FleetId
    def description: Optional[Description]
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetRequest
  ) extends zio.aws.iotfleetwise.model.UpdateFleetRequest.ReadOnly {
    override val fleetId: FleetId =
      zio.aws.iotfleetwise.model.primitives.FleetId(impl.fleetId())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetRequest
  ): zio.aws.iotfleetwise.model.UpdateFleetRequest.ReadOnly = new Wrapper(impl)
}
