package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Arn, FleetId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFleetResponse(
    id: Optional[FleetId] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetResponse = {
    import UpdateFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetResponse
      .builder()
      .optionallyWith(id.map(value => FleetId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.UpdateFleetResponse.ReadOnly =
    zio.aws.iotfleetwise.model.UpdateFleetResponse.wrap(buildAwsValue())
}
object UpdateFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.UpdateFleetResponse =
      zio.aws.iotfleetwise.model
        .UpdateFleetResponse(id.map(value => value), arn.map(value => value))
    def id: Optional[FleetId]
    def arn: Optional[Arn]
    def getId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetResponse
  ) extends zio.aws.iotfleetwise.model.UpdateFleetResponse.ReadOnly {
    override val id: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotfleetwise.model.primitives.FleetId(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetResponse
  ): zio.aws.iotfleetwise.model.UpdateFleetResponse.ReadOnly = new Wrapper(impl)
}
