package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{
  NodePath,
  Description,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateModelManifestRequest(
    name: ResourceName,
    description: Optional[Description] = Optional.Absent,
    nodesToAdd: Optional[Iterable[NodePath]] = Optional.Absent,
    nodesToRemove: Optional[Iterable[NodePath]] = Optional.Absent,
    status: Optional[zio.aws.iotfleetwise.model.ManifestStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestRequest = {
    import UpdateModelManifestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        nodesToAdd.map(value =>
          value.map { item =>
            NodePath.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.nodesToAdd)
      .optionallyWith(
        nodesToRemove.map(value =>
          value.map { item =>
            NodePath.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.nodesToRemove)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.UpdateModelManifestRequest.ReadOnly =
    zio.aws.iotfleetwise.model.UpdateModelManifestRequest.wrap(buildAwsValue())
}
object UpdateModelManifestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.UpdateModelManifestRequest =
      zio.aws.iotfleetwise.model.UpdateModelManifestRequest(
        name,
        description.map(value => value),
        nodesToAdd.map(value => value),
        nodesToRemove.map(value => value),
        status.map(value => value)
      )
    def name: ResourceName
    def description: Optional[Description]
    def nodesToAdd: Optional[List[NodePath]]
    def nodesToRemove: Optional[List[NodePath]]
    def status: Optional[zio.aws.iotfleetwise.model.ManifestStatus]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNodesToAdd: ZIO[Any, AwsError, List[NodePath]] =
      AwsError.unwrapOptionField("nodesToAdd", nodesToAdd)
    def getNodesToRemove: ZIO[Any, AwsError, List[NodePath]] =
      AwsError.unwrapOptionField("nodesToRemove", nodesToRemove)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.ManifestStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestRequest
  ) extends zio.aws.iotfleetwise.model.UpdateModelManifestRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val nodesToAdd: Optional[List[NodePath]] = zio.aws.core.internal
      .optionalFromNullable(impl.nodesToAdd())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.primitives.NodePath(item)
        }.toList
      )
    override val nodesToRemove: Optional[List[NodePath]] = zio.aws.core.internal
      .optionalFromNullable(impl.nodesToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.primitives.NodePath(item)
        }.toList
      )
    override val status: Optional[zio.aws.iotfleetwise.model.ManifestStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotfleetwise.model.ManifestStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestRequest
  ): zio.aws.iotfleetwise.model.UpdateModelManifestRequest.ReadOnly =
    new Wrapper(impl)
}
