package zio.aws.iotfleetwise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.iotfleetwise.model.primitives.{Number, VehicleName}
import scala.jdk.CollectionConverters.*
final case class UpdateVehicleError(
    vehicleName: Optional[VehicleName] = Optional.Absent,
    code: Optional[Number] = Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleError = {
    import UpdateVehicleError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleError
      .builder()
      .optionallyWith(
        vehicleName.map(value => VehicleName.unwrap(value): java.lang.String)
      )(_.vehicleName)
      .optionallyWith(code.map(value => Number.unwrap(value): Integer))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.UpdateVehicleError.ReadOnly =
    zio.aws.iotfleetwise.model.UpdateVehicleError.wrap(buildAwsValue())
}
object UpdateVehicleError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.UpdateVehicleError =
      zio.aws.iotfleetwise.model.UpdateVehicleError(
        vehicleName.map(value => value),
        code.map(value => value),
        message.map(value => value)
      )
    def vehicleName: Optional[VehicleName]
    def code: Optional[Number]
    def message: Optional[String]
    def getVehicleName: ZIO[Any, AwsError, VehicleName] =
      AwsError.unwrapOptionField("vehicleName", vehicleName)
    def getCode: ZIO[Any, AwsError, Number] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleError
  ) extends zio.aws.iotfleetwise.model.UpdateVehicleError.ReadOnly {
    override val vehicleName: Optional[VehicleName] = zio.aws.core.internal
      .optionalFromNullable(impl.vehicleName())
      .map(value => zio.aws.iotfleetwise.model.primitives.VehicleName(value))
    override val code: Optional[Number] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => zio.aws.iotfleetwise.model.primitives.Number(value))
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleError
  ): zio.aws.iotfleetwise.model.UpdateVehicleError.ReadOnly = new Wrapper(impl)
}
