package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{
  AttributeValue,
  AttributeName,
  Arn,
  VehicleName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateVehicleRequest(
    vehicleName: VehicleName,
    modelManifestArn: Optional[Arn] = Optional.Absent,
    decoderManifestArn: Optional[Arn] = Optional.Absent,
    attributes: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent,
    attributeUpdateMode: Optional[zio.aws.iotfleetwise.model.UpdateMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequest = {
    import UpdateVehicleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequest
      .builder()
      .vehicleName(VehicleName.unwrap(vehicleName): java.lang.String)
      .optionallyWith(
        modelManifestArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.modelManifestArn)
      .optionallyWith(
        decoderManifestArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.decoderManifestArn)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(attributeUpdateMode.map(value => value.unwrap))(
        _.attributeUpdateMode
      )
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.UpdateVehicleRequest.ReadOnly =
    zio.aws.iotfleetwise.model.UpdateVehicleRequest.wrap(buildAwsValue())
}
object UpdateVehicleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.UpdateVehicleRequest =
      zio.aws.iotfleetwise.model.UpdateVehicleRequest(
        vehicleName,
        modelManifestArn.map(value => value),
        decoderManifestArn.map(value => value),
        attributes.map(value => value),
        attributeUpdateMode.map(value => value)
      )
    def vehicleName: VehicleName
    def modelManifestArn: Optional[Arn]
    def decoderManifestArn: Optional[Arn]
    def attributes: Optional[Map[AttributeName, AttributeValue]]
    def attributeUpdateMode: Optional[zio.aws.iotfleetwise.model.UpdateMode]
    def getVehicleName: ZIO[Any, Nothing, VehicleName] =
      ZIO.succeed(vehicleName)
    def getModelManifestArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("modelManifestArn", modelManifestArn)
    def getDecoderManifestArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("decoderManifestArn", decoderManifestArn)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getAttributeUpdateMode
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.UpdateMode] =
      AwsError.unwrapOptionField("attributeUpdateMode", attributeUpdateMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequest
  ) extends zio.aws.iotfleetwise.model.UpdateVehicleRequest.ReadOnly {
    override val vehicleName: VehicleName =
      zio.aws.iotfleetwise.model.primitives.VehicleName(impl.vehicleName())
    override val modelManifestArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelManifestArn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val decoderManifestArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.decoderManifestArn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val attributes: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iotfleetwise.model.primitives.AttributeName(
                key
              ) -> zio.aws.iotfleetwise.model.primitives.AttributeValue(value)
            })
            .toMap
        )
    override val attributeUpdateMode
        : Optional[zio.aws.iotfleetwise.model.UpdateMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeUpdateMode())
        .map(value => zio.aws.iotfleetwise.model.UpdateMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequest
  ): zio.aws.iotfleetwise.model.UpdateVehicleRequest.ReadOnly = new Wrapper(
    impl
  )
}
