package zio.aws.iotfleetwise
import zio.aws.iotfleetwise.model.primitives.ResourceName.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.iotfleetwise.model.primitives.{
  FleetId,
  AttributeName,
  FullyQualifiedName,
  VehicleName,
  NetworkFileBlob,
  NodePath,
  InterfaceId,
  AttributeValue,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.iotfleetwise.model.primitives.AmazonResourceName.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.iotfleetwise.model.primitives.Arn.Type
    object AttributeName extends Subtype[String]
    type AttributeName =
      zio.aws.iotfleetwise.model.primitives.AttributeName.Type
    object AttributeValue extends Subtype[String]
    type AttributeValue =
      zio.aws.iotfleetwise.model.primitives.AttributeValue.Type
    object CampaignName extends Subtype[String]
    type CampaignName = zio.aws.iotfleetwise.model.primitives.CampaignName.Type
    object CanInterfaceName extends Subtype[String]
    type CanInterfaceName =
      zio.aws.iotfleetwise.model.primitives.CanInterfaceName.Type
    object CanSignalName extends Subtype[String]
    type CanSignalName =
      zio.aws.iotfleetwise.model.primitives.CanSignalName.Type
    object CloudWatchLogGroupName extends Subtype[String]
    type CloudWatchLogGroupName =
      zio.aws.iotfleetwise.model.primitives.CloudWatchLogGroupName.Type
    object CollectionPeriodMs extends Subtype[Long]
    type CollectionPeriodMs =
      zio.aws.iotfleetwise.model.primitives.CollectionPeriodMs.Type
    object CustomerAccountId extends Subtype[String]
    type CustomerAccountId =
      zio.aws.iotfleetwise.model.primitives.CustomerAccountId.Type
    object Description extends Subtype[String]
    type Description = zio.aws.iotfleetwise.model.primitives.Description.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.iotfleetwise.model.primitives.ErrorMessage.Type
    object EventExpression extends Subtype[String]
    type EventExpression =
      zio.aws.iotfleetwise.model.primitives.EventExpression.Type
    object FleetId extends Subtype[String]
    type FleetId = zio.aws.iotfleetwise.model.primitives.FleetId.Type
    object FullyQualifiedName extends Subtype[String]
    type FullyQualifiedName =
      zio.aws.iotfleetwise.model.primitives.FullyQualifiedName.Type
    object IAMRoleArn extends Subtype[String]
    type IAMRoleArn = zio.aws.iotfleetwise.model.primitives.IAMRoleArn.Type
    object InterfaceId extends Subtype[String]
    type InterfaceId = zio.aws.iotfleetwise.model.primitives.InterfaceId.Type
    object LanguageVersion extends Subtype[Int]
    type LanguageVersion =
      zio.aws.iotfleetwise.model.primitives.LanguageVersion.Type
    object ListVehiclesMaxResults extends Subtype[Int]
    type ListVehiclesMaxResults =
      zio.aws.iotfleetwise.model.primitives.ListVehiclesMaxResults.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.iotfleetwise.model.primitives.MaxResults.Type
    object MaxSampleCount extends Subtype[Long]
    type MaxSampleCount =
      zio.aws.iotfleetwise.model.primitives.MaxSampleCount.Type
    object Message extends Subtype[String]
    type Message = zio.aws.iotfleetwise.model.primitives.Message.Type
    object NetworkFileBlob extends Subtype[Chunk[Byte]]
    type NetworkFileBlob =
      zio.aws.iotfleetwise.model.primitives.NetworkFileBlob.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.iotfleetwise.model.primitives.NextToken.Type
    object NodePath extends Subtype[String]
    type NodePath = zio.aws.iotfleetwise.model.primitives.NodePath.Type
    object NonNegativeInteger extends Subtype[Int]
    type NonNegativeInteger =
      zio.aws.iotfleetwise.model.primitives.NonNegativeInteger.Type
    object Number extends Subtype[Int]
    type Number = zio.aws.iotfleetwise.model.primitives.Number.Type
    object ObdBitmaskLength extends Subtype[Int]
    type ObdBitmaskLength =
      zio.aws.iotfleetwise.model.primitives.ObdBitmaskLength.Type
    object ObdByteLength extends Subtype[Int]
    type ObdByteLength =
      zio.aws.iotfleetwise.model.primitives.ObdByteLength.Type
    object ObdInterfaceName extends Subtype[String]
    type ObdInterfaceName =
      zio.aws.iotfleetwise.model.primitives.ObdInterfaceName.Type
    object ObdStandard extends Subtype[String]
    type ObdStandard = zio.aws.iotfleetwise.model.primitives.ObdStandard.Type
    object PositiveInteger extends Subtype[Int]
    type PositiveInteger =
      zio.aws.iotfleetwise.model.primitives.PositiveInteger.Type
    object Prefix extends Subtype[String]
    type Prefix = zio.aws.iotfleetwise.model.primitives.Prefix.Type
    object Priority extends Subtype[Int]
    type Priority = zio.aws.iotfleetwise.model.primitives.Priority.Type
    object ProtocolName extends Subtype[String]
    type ProtocolName = zio.aws.iotfleetwise.model.primitives.ProtocolName.Type
    object ProtocolVersion extends Subtype[String]
    type ProtocolVersion =
      zio.aws.iotfleetwise.model.primitives.ProtocolVersion.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.iotfleetwise.model.primitives.ResourceName.Type
    object S3BucketArn extends Subtype[String]
    type S3BucketArn = zio.aws.iotfleetwise.model.primitives.S3BucketArn.Type
    object Status extends Subtype[String]
    type Status = zio.aws.iotfleetwise.model.primitives.Status.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.iotfleetwise.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.iotfleetwise.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.iotfleetwise.model.primitives.Timestamp.Type
    object TimestreamDatabaseName extends Subtype[String]
    type TimestreamDatabaseName =
      zio.aws.iotfleetwise.model.primitives.TimestreamDatabaseName.Type
    object TimestreamTableArn extends Subtype[String]
    type TimestreamTableArn =
      zio.aws.iotfleetwise.model.primitives.TimestreamTableArn.Type
    object TimestreamTableName extends Subtype[String]
    type TimestreamTableName =
      zio.aws.iotfleetwise.model.primitives.TimestreamTableName.Type
    object Uint32 extends Subtype[Long]
    type Uint32 = zio.aws.iotfleetwise.model.primitives.Uint32.Type
    object VehicleName extends Subtype[String]
    type VehicleName = zio.aws.iotfleetwise.model.primitives.VehicleName.Type
    object WildcardSignalName extends Subtype[String]
    type WildcardSignalName =
      zio.aws.iotfleetwise.model.primitives.WildcardSignalName.Type
  }
  type AttributesMap = Map[AttributeName, AttributeValue]
  type CampaignSummaries = List[zio.aws.iotfleetwise.model.CampaignSummary]
  type CreateVehicleErrors = List[zio.aws.iotfleetwise.model.CreateVehicleError]
  type CreateVehicleRequestItems =
    List[zio.aws.iotfleetwise.model.CreateVehicleRequestItem]
  type CreateVehicleResponses =
    List[zio.aws.iotfleetwise.model.CreateVehicleResponseItem]
  type DataDestinationConfigs =
    List[zio.aws.iotfleetwise.model.DataDestinationConfig]
  type DataExtraDimensionNodePathList = List[NodePath]
  type DecoderManifestSummaries =
    List[zio.aws.iotfleetwise.model.DecoderManifestSummary]
  type FleetSummaries = List[zio.aws.iotfleetwise.model.FleetSummary]
  type Fleets = List[FleetId]
  type Fqns = List[FullyQualifiedName]
  type InterfaceIds = List[InterfaceId]
  type ListOfStrings = List[String]
  type ModelManifestSummaries =
    List[zio.aws.iotfleetwise.model.ModelManifestSummary]
  type ModelSignalsMap = Map[String, String]
  type NetworkFileDefinitions =
    List[zio.aws.iotfleetwise.model.NetworkFileDefinition]
  type NetworkFilesList = List[NetworkFileBlob]
  type NetworkInterfaces = List[zio.aws.iotfleetwise.model.NetworkInterface]
  type NodePaths = List[NodePath]
  type Nodes = List[zio.aws.iotfleetwise.model.Node]
  type SignalCatalogSummaries =
    List[zio.aws.iotfleetwise.model.SignalCatalogSummary]
  type SignalDecoders = List[zio.aws.iotfleetwise.model.SignalDecoder]
  type SignalInformationList =
    List[zio.aws.iotfleetwise.model.SignalInformation]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.iotfleetwise.model.Tag]
  type UpdateVehicleErrors = List[zio.aws.iotfleetwise.model.UpdateVehicleError]
  type UpdateVehicleRequestItems =
    List[zio.aws.iotfleetwise.model.UpdateVehicleRequestItem]
  type UpdateVehicleResponseItems =
    List[zio.aws.iotfleetwise.model.UpdateVehicleResponseItem]
  type VehicleStatusList = List[zio.aws.iotfleetwise.model.VehicleStatus]
  type VehicleSummaries = List[zio.aws.iotfleetwise.model.VehicleSummary]
  type Vehicles = List[VehicleName]
}
