package zio.aws.iotroborunner
import software.amazon.awssdk.services.iotroborunner.model.{
  GetDestinationResponse,
  GetWorkerFleetResponse,
  UpdateWorkerResponse,
  CreateSiteResponse,
  GetSiteResponse,
  DeleteWorkerFleetRequest,
  ListWorkersRequest,
  DeleteDestinationResponse,
  DeleteSiteRequest,
  Destination,
  UpdateDestinationRequest,
  UpdateSiteResponse,
  Worker,
  Site,
  CreateWorkerFleetResponse,
  CreateDestinationResponse,
  UpdateDestinationResponse,
  UpdateWorkerFleetResponse,
  CreateDestinationRequest,
  UpdateSiteRequest,
  DeleteWorkerRequest,
  WorkerFleet,
  DeleteSiteResponse,
  ListWorkerFleetsResponse,
  CreateWorkerRequest,
  DeleteWorkerFleetResponse,
  DeleteDestinationRequest,
  ListDestinationsRequest,
  UpdateWorkerFleetRequest,
  GetWorkerRequest,
  GetSiteRequest,
  GetWorkerResponse,
  GetDestinationRequest,
  ListWorkersResponse,
  UpdateWorkerRequest,
  ListSitesResponse,
  DeleteWorkerResponse,
  CreateWorkerResponse,
  ListSitesRequest,
  ListWorkerFleetsRequest,
  CreateWorkerFleetRequest,
  CreateSiteRequest,
  ListDestinationsResponse,
  GetWorkerFleetRequest
}
import zio.aws.iotroborunner.model.GetSiteResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.iotroborunner.{
  IotRoboRunnerAsyncClientBuilder,
  IotRoboRunnerAsyncClient
}
import software.amazon.awssdk.services.iotroborunner.paginators.{
  ListWorkersPublisher,
  ListWorkerFleetsPublisher,
  ListDestinationsPublisher,
  ListSitesPublisher
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait IotRoboRunner extends AspectSupport[IotRoboRunner] {
  val api: IotRoboRunnerAsyncClient
  def deleteWorker(
      request: zio.aws.iotroborunner.model.DeleteWorkerRequest
  ): IO[AwsError, zio.aws.iotroborunner.model.DeleteWorkerResponse.ReadOnly]
  def getSite(
      request: zio.aws.iotroborunner.model.GetSiteRequest
  ): IO[AwsError, ReadOnly]
  def createSite(
      request: zio.aws.iotroborunner.model.CreateSiteRequest
  ): IO[AwsError, zio.aws.iotroborunner.model.CreateSiteResponse.ReadOnly]
  def createWorker(
      request: zio.aws.iotroborunner.model.CreateWorkerRequest
  ): IO[AwsError, zio.aws.iotroborunner.model.CreateWorkerResponse.ReadOnly]
  def listSites(
      request: zio.aws.iotroborunner.model.ListSitesRequest
  ): ZStream[Any, AwsError, zio.aws.iotroborunner.model.Site.ReadOnly]
  def listSitesPaginated(
      request: zio.aws.iotroborunner.model.ListSitesRequest
  ): IO[AwsError, zio.aws.iotroborunner.model.ListSitesResponse.ReadOnly]
  def createDestination(
      request: zio.aws.iotroborunner.model.CreateDestinationRequest
  ): IO[
    AwsError,
    zio.aws.iotroborunner.model.CreateDestinationResponse.ReadOnly
  ]
  def listDestinations(
      request: zio.aws.iotroborunner.model.ListDestinationsRequest
  ): ZStream[Any, AwsError, zio.aws.iotroborunner.model.Destination.ReadOnly]
  def listDestinationsPaginated(
      request: zio.aws.iotroborunner.model.ListDestinationsRequest
  ): IO[AwsError, zio.aws.iotroborunner.model.ListDestinationsResponse.ReadOnly]
  def listWorkerFleets(
      request: zio.aws.iotroborunner.model.ListWorkerFleetsRequest
  ): ZStream[Any, AwsError, zio.aws.iotroborunner.model.WorkerFleet.ReadOnly]
  def listWorkerFleetsPaginated(
      request: zio.aws.iotroborunner.model.ListWorkerFleetsRequest
  ): IO[AwsError, zio.aws.iotroborunner.model.ListWorkerFleetsResponse.ReadOnly]
  def getWorkerFleet(
      request: zio.aws.iotroborunner.model.GetWorkerFleetRequest
  ): IO[AwsError, zio.aws.iotroborunner.model.GetWorkerFleetResponse.ReadOnly]
  def updateDestination(
      request: zio.aws.iotroborunner.model.UpdateDestinationRequest
  ): IO[
    AwsError,
    zio.aws.iotroborunner.model.UpdateDestinationResponse.ReadOnly
  ]
  def deleteSite(
      request: zio.aws.iotroborunner.model.DeleteSiteRequest
  ): IO[AwsError, zio.aws.iotroborunner.model.DeleteSiteResponse.ReadOnly]
  def createWorkerFleet(
      request: zio.aws.iotroborunner.model.CreateWorkerFleetRequest
  ): IO[
    AwsError,
    zio.aws.iotroborunner.model.CreateWorkerFleetResponse.ReadOnly
  ]
  def listWorkers(
      request: zio.aws.iotroborunner.model.ListWorkersRequest
  ): ZStream[Any, AwsError, zio.aws.iotroborunner.model.Worker.ReadOnly]
  def listWorkersPaginated(
      request: zio.aws.iotroborunner.model.ListWorkersRequest
  ): IO[AwsError, zio.aws.iotroborunner.model.ListWorkersResponse.ReadOnly]
  def updateWorker(
      request: zio.aws.iotroborunner.model.UpdateWorkerRequest
  ): IO[AwsError, zio.aws.iotroborunner.model.UpdateWorkerResponse.ReadOnly]
  def updateWorkerFleet(
      request: zio.aws.iotroborunner.model.UpdateWorkerFleetRequest
  ): IO[
    AwsError,
    zio.aws.iotroborunner.model.UpdateWorkerFleetResponse.ReadOnly
  ]
  def deleteWorkerFleet(
      request: zio.aws.iotroborunner.model.DeleteWorkerFleetRequest
  ): IO[
    AwsError,
    zio.aws.iotroborunner.model.DeleteWorkerFleetResponse.ReadOnly
  ]
  def getDestination(
      request: zio.aws.iotroborunner.model.GetDestinationRequest
  ): IO[AwsError, zio.aws.iotroborunner.model.GetDestinationResponse.ReadOnly]
  def getWorker(
      request: zio.aws.iotroborunner.model.GetWorkerRequest
  ): IO[AwsError, zio.aws.iotroborunner.model.GetWorkerResponse.ReadOnly]
  def updateSite(
      request: zio.aws.iotroborunner.model.UpdateSiteRequest
  ): IO[AwsError, zio.aws.iotroborunner.model.UpdateSiteResponse.ReadOnly]
  def deleteDestination(
      request: zio.aws.iotroborunner.model.DeleteDestinationRequest
  ): IO[
    AwsError,
    zio.aws.iotroborunner.model.DeleteDestinationResponse.ReadOnly
  ]
}
object IotRoboRunner {
  val live: ZLayer[AwsConfig, java.lang.Throwable, IotRoboRunner] = customized(
    identity
  )
  def customized(
      customization: IotRoboRunnerAsyncClientBuilder => IotRoboRunnerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, IotRoboRunner] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: IotRoboRunnerAsyncClientBuilder => IotRoboRunnerAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, IotRoboRunner] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = IotRoboRunnerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[IotRoboRunnerAsyncClient, IotRoboRunnerAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      IotRoboRunnerAsyncClient,
      IotRoboRunnerAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new IotRoboRunnerImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class IotRoboRunnerImpl[R](
      override val api: IotRoboRunnerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends IotRoboRunner
      with AwsServiceBase[R] {
    override val serviceName: String = "IotRoboRunner"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IotRoboRunnerImpl[R1] = new IotRoboRunnerImpl(api, newAspect, r)
    def deleteWorker(
        request: zio.aws.iotroborunner.model.DeleteWorkerRequest
    ): IO[AwsError, zio.aws.iotroborunner.model.DeleteWorkerResponse.ReadOnly] =
      asyncRequestResponse[DeleteWorkerRequest, DeleteWorkerResponse](
        "deleteWorker",
        api.deleteWorker
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.DeleteWorkerResponse.wrap)
        .provideEnvironment(r)
    def getSite(
        request: zio.aws.iotroborunner.model.GetSiteRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[GetSiteRequest, GetSiteResponse](
        "getSite",
        api.getSite
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.GetSiteResponse.wrap)
        .provideEnvironment(r)
    def createSite(
        request: zio.aws.iotroborunner.model.CreateSiteRequest
    ): IO[AwsError, zio.aws.iotroborunner.model.CreateSiteResponse.ReadOnly] =
      asyncRequestResponse[CreateSiteRequest, CreateSiteResponse](
        "createSite",
        api.createSite
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.CreateSiteResponse.wrap)
        .provideEnvironment(r)
    def createWorker(
        request: zio.aws.iotroborunner.model.CreateWorkerRequest
    ): IO[AwsError, zio.aws.iotroborunner.model.CreateWorkerResponse.ReadOnly] =
      asyncRequestResponse[CreateWorkerRequest, CreateWorkerResponse](
        "createWorker",
        api.createWorker
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.CreateWorkerResponse.wrap)
        .provideEnvironment(r)
    def listSites(
        request: zio.aws.iotroborunner.model.ListSitesRequest
    ): ZStream[Any, AwsError, zio.aws.iotroborunner.model.Site.ReadOnly] =
      asyncJavaPaginatedRequest[ListSitesRequest, Site, ListSitesPublisher](
        "listSites",
        api.listSitesPaginator,
        _.sites()
      )(request.buildAwsValue())
        .map(item => zio.aws.iotroborunner.model.Site.wrap(item))
        .provideEnvironment(r)
    def listSitesPaginated(
        request: zio.aws.iotroborunner.model.ListSitesRequest
    ): IO[AwsError, zio.aws.iotroborunner.model.ListSitesResponse.ReadOnly] =
      asyncRequestResponse[ListSitesRequest, ListSitesResponse](
        "listSites",
        api.listSites
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.ListSitesResponse.wrap)
        .provideEnvironment(r)
    def createDestination(
        request: zio.aws.iotroborunner.model.CreateDestinationRequest
    ): IO[
      AwsError,
      zio.aws.iotroborunner.model.CreateDestinationResponse.ReadOnly
    ] =
      asyncRequestResponse[CreateDestinationRequest, CreateDestinationResponse](
        "createDestination",
        api.createDestination
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.CreateDestinationResponse.wrap)
        .provideEnvironment(r)
    def listDestinations(
        request: zio.aws.iotroborunner.model.ListDestinationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotroborunner.model.Destination.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListDestinationsRequest,
      Destination,
      ListDestinationsPublisher
    ]("listDestinations", api.listDestinationsPaginator, _.destinations())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotroborunner.model.Destination.wrap(item))
      .provideEnvironment(r)
    def listDestinationsPaginated(
        request: zio.aws.iotroborunner.model.ListDestinationsRequest
    ): IO[
      AwsError,
      zio.aws.iotroborunner.model.ListDestinationsResponse.ReadOnly
    ] = asyncRequestResponse[ListDestinationsRequest, ListDestinationsResponse](
      "listDestinations",
      api.listDestinations
    )(request.buildAwsValue())
      .map(zio.aws.iotroborunner.model.ListDestinationsResponse.wrap)
      .provideEnvironment(r)
    def listWorkerFleets(
        request: zio.aws.iotroborunner.model.ListWorkerFleetsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotroborunner.model.WorkerFleet.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListWorkerFleetsRequest,
      WorkerFleet,
      ListWorkerFleetsPublisher
    ]("listWorkerFleets", api.listWorkerFleetsPaginator, _.workerFleets())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotroborunner.model.WorkerFleet.wrap(item))
      .provideEnvironment(r)
    def listWorkerFleetsPaginated(
        request: zio.aws.iotroborunner.model.ListWorkerFleetsRequest
    ): IO[
      AwsError,
      zio.aws.iotroborunner.model.ListWorkerFleetsResponse.ReadOnly
    ] = asyncRequestResponse[ListWorkerFleetsRequest, ListWorkerFleetsResponse](
      "listWorkerFleets",
      api.listWorkerFleets
    )(request.buildAwsValue())
      .map(zio.aws.iotroborunner.model.ListWorkerFleetsResponse.wrap)
      .provideEnvironment(r)
    def getWorkerFleet(
        request: zio.aws.iotroborunner.model.GetWorkerFleetRequest
    ): IO[
      AwsError,
      zio.aws.iotroborunner.model.GetWorkerFleetResponse.ReadOnly
    ] = asyncRequestResponse[GetWorkerFleetRequest, GetWorkerFleetResponse](
      "getWorkerFleet",
      api.getWorkerFleet
    )(request.buildAwsValue())
      .map(zio.aws.iotroborunner.model.GetWorkerFleetResponse.wrap)
      .provideEnvironment(r)
    def updateDestination(
        request: zio.aws.iotroborunner.model.UpdateDestinationRequest
    ): IO[
      AwsError,
      zio.aws.iotroborunner.model.UpdateDestinationResponse.ReadOnly
    ] =
      asyncRequestResponse[UpdateDestinationRequest, UpdateDestinationResponse](
        "updateDestination",
        api.updateDestination
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.UpdateDestinationResponse.wrap)
        .provideEnvironment(r)
    def deleteSite(
        request: zio.aws.iotroborunner.model.DeleteSiteRequest
    ): IO[AwsError, zio.aws.iotroborunner.model.DeleteSiteResponse.ReadOnly] =
      asyncRequestResponse[DeleteSiteRequest, DeleteSiteResponse](
        "deleteSite",
        api.deleteSite
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.DeleteSiteResponse.wrap)
        .provideEnvironment(r)
    def createWorkerFleet(
        request: zio.aws.iotroborunner.model.CreateWorkerFleetRequest
    ): IO[
      AwsError,
      zio.aws.iotroborunner.model.CreateWorkerFleetResponse.ReadOnly
    ] =
      asyncRequestResponse[CreateWorkerFleetRequest, CreateWorkerFleetResponse](
        "createWorkerFleet",
        api.createWorkerFleet
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.CreateWorkerFleetResponse.wrap)
        .provideEnvironment(r)
    def listWorkers(
        request: zio.aws.iotroborunner.model.ListWorkersRequest
    ): ZStream[Any, AwsError, zio.aws.iotroborunner.model.Worker.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListWorkersRequest,
        Worker,
        ListWorkersPublisher
      ]("listWorkers", api.listWorkersPaginator, _.workers())(
        request.buildAwsValue()
      ).map(item => zio.aws.iotroborunner.model.Worker.wrap(item))
        .provideEnvironment(r)
    def listWorkersPaginated(
        request: zio.aws.iotroborunner.model.ListWorkersRequest
    ): IO[AwsError, zio.aws.iotroborunner.model.ListWorkersResponse.ReadOnly] =
      asyncRequestResponse[ListWorkersRequest, ListWorkersResponse](
        "listWorkers",
        api.listWorkers
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.ListWorkersResponse.wrap)
        .provideEnvironment(r)
    def updateWorker(
        request: zio.aws.iotroborunner.model.UpdateWorkerRequest
    ): IO[AwsError, zio.aws.iotroborunner.model.UpdateWorkerResponse.ReadOnly] =
      asyncRequestResponse[UpdateWorkerRequest, UpdateWorkerResponse](
        "updateWorker",
        api.updateWorker
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.UpdateWorkerResponse.wrap)
        .provideEnvironment(r)
    def updateWorkerFleet(
        request: zio.aws.iotroborunner.model.UpdateWorkerFleetRequest
    ): IO[
      AwsError,
      zio.aws.iotroborunner.model.UpdateWorkerFleetResponse.ReadOnly
    ] =
      asyncRequestResponse[UpdateWorkerFleetRequest, UpdateWorkerFleetResponse](
        "updateWorkerFleet",
        api.updateWorkerFleet
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.UpdateWorkerFleetResponse.wrap)
        .provideEnvironment(r)
    def deleteWorkerFleet(
        request: zio.aws.iotroborunner.model.DeleteWorkerFleetRequest
    ): IO[
      AwsError,
      zio.aws.iotroborunner.model.DeleteWorkerFleetResponse.ReadOnly
    ] =
      asyncRequestResponse[DeleteWorkerFleetRequest, DeleteWorkerFleetResponse](
        "deleteWorkerFleet",
        api.deleteWorkerFleet
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.DeleteWorkerFleetResponse.wrap)
        .provideEnvironment(r)
    def getDestination(
        request: zio.aws.iotroborunner.model.GetDestinationRequest
    ): IO[
      AwsError,
      zio.aws.iotroborunner.model.GetDestinationResponse.ReadOnly
    ] = asyncRequestResponse[GetDestinationRequest, GetDestinationResponse](
      "getDestination",
      api.getDestination
    )(request.buildAwsValue())
      .map(zio.aws.iotroborunner.model.GetDestinationResponse.wrap)
      .provideEnvironment(r)
    def getWorker(
        request: zio.aws.iotroborunner.model.GetWorkerRequest
    ): IO[AwsError, zio.aws.iotroborunner.model.GetWorkerResponse.ReadOnly] =
      asyncRequestResponse[GetWorkerRequest, GetWorkerResponse](
        "getWorker",
        api.getWorker
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.GetWorkerResponse.wrap)
        .provideEnvironment(r)
    def updateSite(
        request: zio.aws.iotroborunner.model.UpdateSiteRequest
    ): IO[AwsError, zio.aws.iotroborunner.model.UpdateSiteResponse.ReadOnly] =
      asyncRequestResponse[UpdateSiteRequest, UpdateSiteResponse](
        "updateSite",
        api.updateSite
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.UpdateSiteResponse.wrap)
        .provideEnvironment(r)
    def deleteDestination(
        request: zio.aws.iotroborunner.model.DeleteDestinationRequest
    ): IO[
      AwsError,
      zio.aws.iotroborunner.model.DeleteDestinationResponse.ReadOnly
    ] =
      asyncRequestResponse[DeleteDestinationRequest, DeleteDestinationResponse](
        "deleteDestination",
        api.deleteDestination
      )(request.buildAwsValue())
        .map(zio.aws.iotroborunner.model.DeleteDestinationResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteWorker(
      request: zio.aws.iotroborunner.model.DeleteWorkerRequest
  ): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.DeleteWorkerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorker(request))
  def getSite(
      request: zio.aws.iotroborunner.model.GetSiteRequest
  ): ZIO[zio.aws.iotroborunner.IotRoboRunner, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getSite(request))
  def createSite(request: zio.aws.iotroborunner.model.CreateSiteRequest): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.CreateSiteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSite(request))
  def createWorker(
      request: zio.aws.iotroborunner.model.CreateWorkerRequest
  ): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.CreateWorkerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorker(request))
  def listSites(request: zio.aws.iotroborunner.model.ListSitesRequest): ZStream[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.Site.ReadOnly
  ] = ZStream.serviceWithStream(_.listSites(request))
  def listSitesPaginated(
      request: zio.aws.iotroborunner.model.ListSitesRequest
  ): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.ListSitesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSitesPaginated(request))
  def createDestination(
      request: zio.aws.iotroborunner.model.CreateDestinationRequest
  ): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.CreateDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDestination(request))
  def listDestinations(
      request: zio.aws.iotroborunner.model.ListDestinationsRequest
  ): ZStream[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.Destination.ReadOnly
  ] = ZStream.serviceWithStream(_.listDestinations(request))
  def listDestinationsPaginated(
      request: zio.aws.iotroborunner.model.ListDestinationsRequest
  ): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.ListDestinationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDestinationsPaginated(request))
  def listWorkerFleets(
      request: zio.aws.iotroborunner.model.ListWorkerFleetsRequest
  ): ZStream[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.WorkerFleet.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkerFleets(request))
  def listWorkerFleetsPaginated(
      request: zio.aws.iotroborunner.model.ListWorkerFleetsRequest
  ): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.ListWorkerFleetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkerFleetsPaginated(request))
  def getWorkerFleet(
      request: zio.aws.iotroborunner.model.GetWorkerFleetRequest
  ): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.GetWorkerFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkerFleet(request))
  def updateDestination(
      request: zio.aws.iotroborunner.model.UpdateDestinationRequest
  ): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.UpdateDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDestination(request))
  def deleteSite(request: zio.aws.iotroborunner.model.DeleteSiteRequest): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.DeleteSiteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSite(request))
  def createWorkerFleet(
      request: zio.aws.iotroborunner.model.CreateWorkerFleetRequest
  ): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.CreateWorkerFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkerFleet(request))
  def listWorkers(
      request: zio.aws.iotroborunner.model.ListWorkersRequest
  ): ZStream[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.Worker.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkers(request))
  def listWorkersPaginated(
      request: zio.aws.iotroborunner.model.ListWorkersRequest
  ): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.ListWorkersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkersPaginated(request))
  def updateWorker(
      request: zio.aws.iotroborunner.model.UpdateWorkerRequest
  ): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.UpdateWorkerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorker(request))
  def updateWorkerFleet(
      request: zio.aws.iotroborunner.model.UpdateWorkerFleetRequest
  ): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.UpdateWorkerFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkerFleet(request))
  def deleteWorkerFleet(
      request: zio.aws.iotroborunner.model.DeleteWorkerFleetRequest
  ): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.DeleteWorkerFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkerFleet(request))
  def getDestination(
      request: zio.aws.iotroborunner.model.GetDestinationRequest
  ): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.GetDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDestination(request))
  def getWorker(request: zio.aws.iotroborunner.model.GetWorkerRequest): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.GetWorkerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorker(request))
  def updateSite(request: zio.aws.iotroborunner.model.UpdateSiteRequest): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.UpdateSiteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSite(request))
  def deleteDestination(
      request: zio.aws.iotroborunner.model.DeleteDestinationRequest
  ): ZIO[
    zio.aws.iotroborunner.IotRoboRunner,
    AwsError,
    zio.aws.iotroborunner.model.DeleteDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDestination(request))
}
