package zio.aws.iotroborunner
import zio.aws.iotroborunner.model.GetSiteResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.iotroborunner.IotRoboRunnerAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.aws.iotroborunner.model.{
  DeleteWorkerFleetRequest,
  ListWorkersRequest,
  DeleteSiteRequest,
  UpdateDestinationRequest,
  CreateDestinationRequest,
  UpdateSiteRequest,
  DeleteWorkerRequest,
  CreateWorkerRequest,
  DeleteDestinationRequest,
  ListDestinationsRequest,
  UpdateWorkerFleetRequest,
  GetWorkerRequest,
  GetSiteRequest,
  GetDestinationRequest,
  UpdateWorkerRequest,
  ListSitesRequest,
  ListWorkerFleetsRequest,
  CreateWorkerFleetRequest,
  CreateSiteRequest,
  GetWorkerFleetRequest
}
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object IotRoboRunnerMock extends Mock[IotRoboRunner] {
  object DeleteWorker
      extends Effect[
        DeleteWorkerRequest,
        AwsError,
        zio.aws.iotroborunner.model.DeleteWorkerResponse.ReadOnly
      ]
  object GetSite extends Effect[GetSiteRequest, AwsError, ReadOnly]
  object CreateSite
      extends Effect[
        CreateSiteRequest,
        AwsError,
        zio.aws.iotroborunner.model.CreateSiteResponse.ReadOnly
      ]
  object CreateWorker
      extends Effect[
        CreateWorkerRequest,
        AwsError,
        zio.aws.iotroborunner.model.CreateWorkerResponse.ReadOnly
      ]
  object ListSites
      extends Stream[
        ListSitesRequest,
        AwsError,
        zio.aws.iotroborunner.model.Site.ReadOnly
      ]
  object ListSitesPaginated
      extends Effect[
        ListSitesRequest,
        AwsError,
        zio.aws.iotroborunner.model.ListSitesResponse.ReadOnly
      ]
  object CreateDestination
      extends Effect[
        CreateDestinationRequest,
        AwsError,
        zio.aws.iotroborunner.model.CreateDestinationResponse.ReadOnly
      ]
  object ListDestinations
      extends Stream[
        ListDestinationsRequest,
        AwsError,
        zio.aws.iotroborunner.model.Destination.ReadOnly
      ]
  object ListDestinationsPaginated
      extends Effect[
        ListDestinationsRequest,
        AwsError,
        zio.aws.iotroborunner.model.ListDestinationsResponse.ReadOnly
      ]
  object ListWorkerFleets
      extends Stream[
        ListWorkerFleetsRequest,
        AwsError,
        zio.aws.iotroborunner.model.WorkerFleet.ReadOnly
      ]
  object ListWorkerFleetsPaginated
      extends Effect[
        ListWorkerFleetsRequest,
        AwsError,
        zio.aws.iotroborunner.model.ListWorkerFleetsResponse.ReadOnly
      ]
  object GetWorkerFleet
      extends Effect[
        GetWorkerFleetRequest,
        AwsError,
        zio.aws.iotroborunner.model.GetWorkerFleetResponse.ReadOnly
      ]
  object UpdateDestination
      extends Effect[
        UpdateDestinationRequest,
        AwsError,
        zio.aws.iotroborunner.model.UpdateDestinationResponse.ReadOnly
      ]
  object DeleteSite
      extends Effect[
        DeleteSiteRequest,
        AwsError,
        zio.aws.iotroborunner.model.DeleteSiteResponse.ReadOnly
      ]
  object CreateWorkerFleet
      extends Effect[
        CreateWorkerFleetRequest,
        AwsError,
        zio.aws.iotroborunner.model.CreateWorkerFleetResponse.ReadOnly
      ]
  object ListWorkers
      extends Stream[
        ListWorkersRequest,
        AwsError,
        zio.aws.iotroborunner.model.Worker.ReadOnly
      ]
  object ListWorkersPaginated
      extends Effect[
        ListWorkersRequest,
        AwsError,
        zio.aws.iotroborunner.model.ListWorkersResponse.ReadOnly
      ]
  object UpdateWorker
      extends Effect[
        UpdateWorkerRequest,
        AwsError,
        zio.aws.iotroborunner.model.UpdateWorkerResponse.ReadOnly
      ]
  object UpdateWorkerFleet
      extends Effect[
        UpdateWorkerFleetRequest,
        AwsError,
        zio.aws.iotroborunner.model.UpdateWorkerFleetResponse.ReadOnly
      ]
  object DeleteWorkerFleet
      extends Effect[
        DeleteWorkerFleetRequest,
        AwsError,
        zio.aws.iotroborunner.model.DeleteWorkerFleetResponse.ReadOnly
      ]
  object GetDestination
      extends Effect[
        GetDestinationRequest,
        AwsError,
        zio.aws.iotroborunner.model.GetDestinationResponse.ReadOnly
      ]
  object GetWorker
      extends Effect[
        GetWorkerRequest,
        AwsError,
        zio.aws.iotroborunner.model.GetWorkerResponse.ReadOnly
      ]
  object UpdateSite
      extends Effect[
        UpdateSiteRequest,
        AwsError,
        zio.aws.iotroborunner.model.UpdateSiteResponse.ReadOnly
      ]
  object DeleteDestination
      extends Effect[
        DeleteDestinationRequest,
        AwsError,
        zio.aws.iotroborunner.model.DeleteDestinationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, IotRoboRunner] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, IotRoboRunner] { rts =>
        zio.ZIO.succeed {
          new IotRoboRunner {
            val api: IotRoboRunnerAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): IotRoboRunner = this
            def deleteWorker(request: DeleteWorkerRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.DeleteWorkerResponse.ReadOnly
            ] = proxy(DeleteWorker, request)
            def getSite(request: GetSiteRequest): IO[AwsError, ReadOnly] =
              proxy(GetSite, request)
            def createSite(request: CreateSiteRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.CreateSiteResponse.ReadOnly
            ] = proxy(CreateSite, request)
            def createWorker(request: CreateWorkerRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.CreateWorkerResponse.ReadOnly
            ] = proxy(CreateWorker, request)
            def listSites(request: ListSitesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotroborunner.model.Site.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSites, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSitesPaginated(request: ListSitesRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.ListSitesResponse.ReadOnly
            ] = proxy(ListSitesPaginated, request)
            def createDestination(request: CreateDestinationRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.CreateDestinationResponse.ReadOnly
            ] = proxy(CreateDestination, request)
            def listDestinations(request: ListDestinationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotroborunner.model.Destination.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDestinations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDestinationsPaginated(request: ListDestinationsRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.ListDestinationsResponse.ReadOnly
            ] = proxy(ListDestinationsPaginated, request)
            def listWorkerFleets(request: ListWorkerFleetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotroborunner.model.WorkerFleet.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkerFleets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkerFleetsPaginated(request: ListWorkerFleetsRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.ListWorkerFleetsResponse.ReadOnly
            ] = proxy(ListWorkerFleetsPaginated, request)
            def getWorkerFleet(request: GetWorkerFleetRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.GetWorkerFleetResponse.ReadOnly
            ] = proxy(GetWorkerFleet, request)
            def updateDestination(request: UpdateDestinationRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.UpdateDestinationResponse.ReadOnly
            ] = proxy(UpdateDestination, request)
            def deleteSite(request: DeleteSiteRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.DeleteSiteResponse.ReadOnly
            ] = proxy(DeleteSite, request)
            def createWorkerFleet(request: CreateWorkerFleetRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.CreateWorkerFleetResponse.ReadOnly
            ] = proxy(CreateWorkerFleet, request)
            def listWorkers(request: ListWorkersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotroborunner.model.Worker.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkersPaginated(request: ListWorkersRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.ListWorkersResponse.ReadOnly
            ] = proxy(ListWorkersPaginated, request)
            def updateWorker(request: UpdateWorkerRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.UpdateWorkerResponse.ReadOnly
            ] = proxy(UpdateWorker, request)
            def updateWorkerFleet(request: UpdateWorkerFleetRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.UpdateWorkerFleetResponse.ReadOnly
            ] = proxy(UpdateWorkerFleet, request)
            def deleteWorkerFleet(request: DeleteWorkerFleetRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.DeleteWorkerFleetResponse.ReadOnly
            ] = proxy(DeleteWorkerFleet, request)
            def getDestination(request: GetDestinationRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.GetDestinationResponse.ReadOnly
            ] = proxy(GetDestination, request)
            def getWorker(request: GetWorkerRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.GetWorkerResponse.ReadOnly
            ] = proxy(GetWorker, request)
            def updateSite(request: UpdateSiteRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.UpdateSiteResponse.ReadOnly
            ] = proxy(UpdateSite, request)
            def deleteDestination(request: DeleteDestinationRequest): IO[
              AwsError,
              zio.aws.iotroborunner.model.DeleteDestinationResponse.ReadOnly
            ] = proxy(DeleteDestination, request)
          }
        }
      }
    }
  }
}
