package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CartesianCoordinates(
    x: Double,
    y: Double,
    z: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.CartesianCoordinates = {
    import CartesianCoordinates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.CartesianCoordinates
      .builder()
      .x(x: java.lang.Double)
      .y(y: java.lang.Double)
      .optionallyWith(z.map(value => value: java.lang.Double))(_.z)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.CartesianCoordinates.ReadOnly =
    zio.aws.iotroborunner.model.CartesianCoordinates.wrap(buildAwsValue())
}
object CartesianCoordinates {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.CartesianCoordinates
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.CartesianCoordinates =
      zio.aws.iotroborunner.model
        .CartesianCoordinates(x, y, z.map(value => value))
    def x: Double
    def y: Double
    def z: Optional[Double]
    def getX: ZIO[Any, Nothing, Double] = ZIO.succeed(x)
    def getY: ZIO[Any, Nothing, Double] = ZIO.succeed(y)
    def getZ: ZIO[Any, AwsError, Double] = AwsError.unwrapOptionField("z", z)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.CartesianCoordinates
  ) extends zio.aws.iotroborunner.model.CartesianCoordinates.ReadOnly {
    override val x: Double = impl.x(): Double
    override val y: Double = impl.y(): Double
    override val z: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.z())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.CartesianCoordinates
  ): zio.aws.iotroborunner.model.CartesianCoordinates.ReadOnly = new Wrapper(
    impl
  )
}
