package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotroborunner.model.primitives.{
  SiteDescription,
  SiteCountryCode,
  Name,
  IdempotencyToken
}
import scala.jdk.CollectionConverters.*
final case class CreateSiteRequest(
    clientToken: Optional[IdempotencyToken] = Optional.Absent,
    name: Name,
    countryCode: SiteCountryCode,
    description: Optional[SiteDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.CreateSiteRequest = {
    import CreateSiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.CreateSiteRequest
      .builder()
      .optionallyWith(
        clientToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .name(Name.unwrap(name): java.lang.String)
      .countryCode(SiteCountryCode.unwrap(countryCode): java.lang.String)
      .optionallyWith(
        description.map(value =>
          SiteDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.CreateSiteRequest.ReadOnly =
    zio.aws.iotroborunner.model.CreateSiteRequest.wrap(buildAwsValue())
}
object CreateSiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.CreateSiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.CreateSiteRequest =
      zio.aws.iotroborunner.model.CreateSiteRequest(
        clientToken.map(value => value),
        name,
        countryCode,
        description.map(value => value)
      )
    def clientToken: Optional[IdempotencyToken]
    def name: Name
    def countryCode: SiteCountryCode
    def description: Optional[SiteDescription]
    def getClientToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getCountryCode: ZIO[Any, Nothing, SiteCountryCode] =
      ZIO.succeed(countryCode)
    def getDescription: ZIO[Any, AwsError, SiteDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateSiteRequest
  ) extends zio.aws.iotroborunner.model.CreateSiteRequest.ReadOnly {
    override val clientToken: Optional[IdempotencyToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.IdempotencyToken(value)
      )
    override val name: Name =
      zio.aws.iotroborunner.model.primitives.Name(impl.name())
    override val countryCode: SiteCountryCode =
      zio.aws.iotroborunner.model.primitives.SiteCountryCode(impl.countryCode())
    override val description: Optional[SiteDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.SiteDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateSiteRequest
  ): zio.aws.iotroborunner.model.CreateSiteRequest.ReadOnly = new Wrapper(impl)
}
