package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotroborunner.model.primitives.{
  WorkerFleetAdditionalFixedProperties,
  SiteGenericIdentifier,
  Name,
  IdempotencyToken
}
import scala.jdk.CollectionConverters.*
final case class CreateWorkerFleetRequest(
    clientToken: Optional[IdempotencyToken] = Optional.Absent,
    name: Name,
    site: SiteGenericIdentifier,
    additionalFixedProperties: Optional[WorkerFleetAdditionalFixedProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.CreateWorkerFleetRequest = {
    import CreateWorkerFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.CreateWorkerFleetRequest
      .builder()
      .optionallyWith(
        clientToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .name(Name.unwrap(name): java.lang.String)
      .site(SiteGenericIdentifier.unwrap(site): java.lang.String)
      .optionallyWith(
        additionalFixedProperties.map(value =>
          WorkerFleetAdditionalFixedProperties.unwrap(value): java.lang.String
        )
      )(_.additionalFixedProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.iotroborunner.model.CreateWorkerFleetRequest.ReadOnly =
    zio.aws.iotroborunner.model.CreateWorkerFleetRequest.wrap(buildAwsValue())
}
object CreateWorkerFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.CreateWorkerFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.CreateWorkerFleetRequest =
      zio.aws.iotroborunner.model.CreateWorkerFleetRequest(
        clientToken.map(value => value),
        name,
        site,
        additionalFixedProperties.map(value => value)
      )
    def clientToken: Optional[IdempotencyToken]
    def name: Name
    def site: SiteGenericIdentifier
    def additionalFixedProperties
        : Optional[WorkerFleetAdditionalFixedProperties]
    def getClientToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSite: ZIO[Any, Nothing, SiteGenericIdentifier] = ZIO.succeed(site)
    def getAdditionalFixedProperties
        : ZIO[Any, AwsError, WorkerFleetAdditionalFixedProperties] = AwsError
      .unwrapOptionField("additionalFixedProperties", additionalFixedProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateWorkerFleetRequest
  ) extends zio.aws.iotroborunner.model.CreateWorkerFleetRequest.ReadOnly {
    override val clientToken: Optional[IdempotencyToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.IdempotencyToken(value)
      )
    override val name: Name =
      zio.aws.iotroborunner.model.primitives.Name(impl.name())
    override val site: SiteGenericIdentifier =
      zio.aws.iotroborunner.model.primitives.SiteGenericIdentifier(impl.site())
    override val additionalFixedProperties
        : Optional[WorkerFleetAdditionalFixedProperties] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalFixedProperties())
      .map(value =>
        zio.aws.iotroborunner.model.primitives
          .WorkerFleetAdditionalFixedProperties(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateWorkerFleetRequest
  ): zio.aws.iotroborunner.model.CreateWorkerFleetRequest.ReadOnly =
    new Wrapper(impl)
}
