package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotroborunner.model.primitives.{
  IdempotencyToken,
  WorkerAdditionalFixedPropertiesJson,
  WorkerAdditionalTransientPropertiesJson,
  WorkerFleetGenericIdentifier,
  Name
}
import scala.jdk.CollectionConverters.*
final case class CreateWorkerRequest(
    clientToken: Optional[IdempotencyToken] = Optional.Absent,
    name: Name,
    fleet: WorkerFleetGenericIdentifier,
    additionalTransientProperties: Optional[
      WorkerAdditionalTransientPropertiesJson
    ] = Optional.Absent,
    additionalFixedProperties: Optional[WorkerAdditionalFixedPropertiesJson] =
      Optional.Absent,
    vendorProperties: Optional[zio.aws.iotroborunner.model.VendorProperties] =
      Optional.Absent,
    position: Optional[zio.aws.iotroborunner.model.PositionCoordinates] =
      Optional.Absent,
    orientation: Optional[zio.aws.iotroborunner.model.Orientation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.CreateWorkerRequest = {
    import CreateWorkerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.CreateWorkerRequest
      .builder()
      .optionallyWith(
        clientToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .name(Name.unwrap(name): java.lang.String)
      .fleet(WorkerFleetGenericIdentifier.unwrap(fleet): java.lang.String)
      .optionallyWith(
        additionalTransientProperties.map(value =>
          WorkerAdditionalTransientPropertiesJson.unwrap(
            value
          ): java.lang.String
        )
      )(_.additionalTransientProperties)
      .optionallyWith(
        additionalFixedProperties.map(value =>
          WorkerAdditionalFixedPropertiesJson.unwrap(value): java.lang.String
        )
      )(_.additionalFixedProperties)
      .optionallyWith(vendorProperties.map(value => value.buildAwsValue()))(
        _.vendorProperties
      )
      .optionallyWith(position.map(value => value.buildAwsValue()))(_.position)
      .optionallyWith(orientation.map(value => value.buildAwsValue()))(
        _.orientation
      )
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.CreateWorkerRequest.ReadOnly =
    zio.aws.iotroborunner.model.CreateWorkerRequest.wrap(buildAwsValue())
}
object CreateWorkerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.CreateWorkerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.CreateWorkerRequest =
      zio.aws.iotroborunner.model.CreateWorkerRequest(
        clientToken.map(value => value),
        name,
        fleet,
        additionalTransientProperties.map(value => value),
        additionalFixedProperties.map(value => value),
        vendorProperties.map(value => value.asEditable),
        position.map(value => value.asEditable),
        orientation.map(value => value.asEditable)
      )
    def clientToken: Optional[IdempotencyToken]
    def name: Name
    def fleet: WorkerFleetGenericIdentifier
    def additionalTransientProperties
        : Optional[WorkerAdditionalTransientPropertiesJson]
    def additionalFixedProperties: Optional[WorkerAdditionalFixedPropertiesJson]
    def vendorProperties
        : Optional[zio.aws.iotroborunner.model.VendorProperties.ReadOnly]
    def position
        : Optional[zio.aws.iotroborunner.model.PositionCoordinates.ReadOnly]
    def orientation: Optional[zio.aws.iotroborunner.model.Orientation.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getFleet: ZIO[Any, Nothing, WorkerFleetGenericIdentifier] =
      ZIO.succeed(fleet)
    def getAdditionalTransientProperties
        : ZIO[Any, AwsError, WorkerAdditionalTransientPropertiesJson] =
      AwsError.unwrapOptionField(
        "additionalTransientProperties",
        additionalTransientProperties
      )
    def getAdditionalFixedProperties
        : ZIO[Any, AwsError, WorkerAdditionalFixedPropertiesJson] = AwsError
      .unwrapOptionField("additionalFixedProperties", additionalFixedProperties)
    def getVendorProperties: ZIO[
      Any,
      AwsError,
      zio.aws.iotroborunner.model.VendorProperties.ReadOnly
    ] = AwsError.unwrapOptionField("vendorProperties", vendorProperties)
    def getPosition: ZIO[
      Any,
      AwsError,
      zio.aws.iotroborunner.model.PositionCoordinates.ReadOnly
    ] = AwsError.unwrapOptionField("position", position)
    def getOrientation
        : ZIO[Any, AwsError, zio.aws.iotroborunner.model.Orientation.ReadOnly] =
      AwsError.unwrapOptionField("orientation", orientation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateWorkerRequest
  ) extends zio.aws.iotroborunner.model.CreateWorkerRequest.ReadOnly {
    override val clientToken: Optional[IdempotencyToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.IdempotencyToken(value)
      )
    override val name: Name =
      zio.aws.iotroborunner.model.primitives.Name(impl.name())
    override val fleet: WorkerFleetGenericIdentifier =
      zio.aws.iotroborunner.model.primitives
        .WorkerFleetGenericIdentifier(impl.fleet())
    override val additionalTransientProperties
        : Optional[WorkerAdditionalTransientPropertiesJson] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalTransientProperties())
        .map(value =>
          zio.aws.iotroborunner.model.primitives
            .WorkerAdditionalTransientPropertiesJson(value)
        )
    override val additionalFixedProperties
        : Optional[WorkerAdditionalFixedPropertiesJson] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalFixedProperties())
      .map(value =>
        zio.aws.iotroborunner.model.primitives
          .WorkerAdditionalFixedPropertiesJson(value)
      )
    override val vendorProperties
        : Optional[zio.aws.iotroborunner.model.VendorProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorProperties())
        .map(value => zio.aws.iotroborunner.model.VendorProperties.wrap(value))
    override val position
        : Optional[zio.aws.iotroborunner.model.PositionCoordinates.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.position())
        .map(value =>
          zio.aws.iotroborunner.model.PositionCoordinates.wrap(value)
        )
    override val orientation
        : Optional[zio.aws.iotroborunner.model.Orientation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orientation())
        .map(value => zio.aws.iotroborunner.model.Orientation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateWorkerRequest
  ): zio.aws.iotroborunner.model.CreateWorkerRequest.ReadOnly = new Wrapper(
    impl
  )
}
