package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotroborunner.model.primitives.{
  SiteArn,
  WorkerId,
  UpdatedAtTimestamp,
  CreatedAtTimestamp,
  WorkerArn
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateWorkerResponse(
    arn: WorkerArn,
    id: WorkerId,
    createdAt: CreatedAtTimestamp,
    updatedAt: UpdatedAtTimestamp,
    site: SiteArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.CreateWorkerResponse = {
    import CreateWorkerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.CreateWorkerResponse
      .builder()
      .arn(WorkerArn.unwrap(arn): java.lang.String)
      .id(WorkerId.unwrap(id): java.lang.String)
      .createdAt(CreatedAtTimestamp.unwrap(createdAt): Instant)
      .updatedAt(UpdatedAtTimestamp.unwrap(updatedAt): Instant)
      .site(SiteArn.unwrap(site): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.CreateWorkerResponse.ReadOnly =
    zio.aws.iotroborunner.model.CreateWorkerResponse.wrap(buildAwsValue())
}
object CreateWorkerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.CreateWorkerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.CreateWorkerResponse =
      zio.aws.iotroborunner.model.CreateWorkerResponse(
        arn,
        id,
        createdAt,
        updatedAt,
        site
      )
    def arn: WorkerArn
    def id: WorkerId
    def createdAt: CreatedAtTimestamp
    def updatedAt: UpdatedAtTimestamp
    def site: SiteArn
    def getArn: ZIO[Any, Nothing, WorkerArn] = ZIO.succeed(arn)
    def getId: ZIO[Any, Nothing, WorkerId] = ZIO.succeed(id)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAtTimestamp] =
      ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, UpdatedAtTimestamp] =
      ZIO.succeed(updatedAt)
    def getSite: ZIO[Any, Nothing, SiteArn] = ZIO.succeed(site)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateWorkerResponse
  ) extends zio.aws.iotroborunner.model.CreateWorkerResponse.ReadOnly {
    override val arn: WorkerArn =
      zio.aws.iotroborunner.model.primitives.WorkerArn(impl.arn())
    override val id: WorkerId =
      zio.aws.iotroborunner.model.primitives.WorkerId(impl.id())
    override val createdAt: CreatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .CreatedAtTimestamp(impl.createdAt())
    override val updatedAt: UpdatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .UpdatedAtTimestamp(impl.updatedAt())
    override val site: SiteArn =
      zio.aws.iotroborunner.model.primitives.SiteArn(impl.site())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateWorkerResponse
  ): zio.aws.iotroborunner.model.CreateWorkerResponse.ReadOnly = new Wrapper(
    impl
  )
}
