package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotroborunner.model.primitives.SiteGenericIdentifier
import scala.jdk.CollectionConverters.*
final case class DeleteSiteRequest(id: SiteGenericIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.DeleteSiteRequest = {
    import DeleteSiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.DeleteSiteRequest
      .builder()
      .id(SiteGenericIdentifier.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.DeleteSiteRequest.ReadOnly =
    zio.aws.iotroborunner.model.DeleteSiteRequest.wrap(buildAwsValue())
}
object DeleteSiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.DeleteSiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.DeleteSiteRequest =
      zio.aws.iotroborunner.model.DeleteSiteRequest(id)
    def id: SiteGenericIdentifier
    def getId: ZIO[Any, Nothing, SiteGenericIdentifier] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.DeleteSiteRequest
  ) extends zio.aws.iotroborunner.model.DeleteSiteRequest.ReadOnly {
    override val id: SiteGenericIdentifier =
      zio.aws.iotroborunner.model.primitives.SiteGenericIdentifier(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.DeleteSiteRequest
  ): zio.aws.iotroborunner.model.DeleteSiteRequest.ReadOnly = new Wrapper(impl)
}
