package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotroborunner.model.primitives.DestinationGenericIdentifier
import scala.jdk.CollectionConverters.*
final case class GetDestinationRequest(id: DestinationGenericIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.GetDestinationRequest = {
    import GetDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.GetDestinationRequest
      .builder()
      .id(DestinationGenericIdentifier.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.GetDestinationRequest.ReadOnly =
    zio.aws.iotroborunner.model.GetDestinationRequest.wrap(buildAwsValue())
}
object GetDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.GetDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.GetDestinationRequest =
      zio.aws.iotroborunner.model.GetDestinationRequest(id)
    def id: DestinationGenericIdentifier
    def getId: ZIO[Any, Nothing, DestinationGenericIdentifier] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetDestinationRequest
  ) extends zio.aws.iotroborunner.model.GetDestinationRequest.ReadOnly {
    override val id: DestinationGenericIdentifier =
      zio.aws.iotroborunner.model.primitives
        .DestinationGenericIdentifier(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetDestinationRequest
  ): zio.aws.iotroborunner.model.GetDestinationRequest.ReadOnly = new Wrapper(
    impl
  )
}
