package zio.aws.iotroborunner.model
import java.time.Instant
import zio.aws.iotroborunner.model.primitives.{
  SiteArn,
  SiteCountryCode,
  SiteDescription,
  UpdatedAtTimestamp,
  SiteId,
  CreatedAtTimestamp,
  Name
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetSiteResponse(
    arn: SiteArn,
    id: SiteId,
    name: Name,
    countryCode: SiteCountryCode,
    description: Optional[SiteDescription] = Optional.Absent,
    createdAt: CreatedAtTimestamp,
    updatedAt: UpdatedAtTimestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.GetSiteResponse = {
    import GetSiteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.GetSiteResponse
      .builder()
      .arn(SiteArn.unwrap(arn): java.lang.String)
      .id(SiteId.unwrap(id): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .countryCode(SiteCountryCode.unwrap(countryCode): java.lang.String)
      .optionallyWith(
        description.map(value =>
          SiteDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .createdAt(CreatedAtTimestamp.unwrap(createdAt): Instant)
      .updatedAt(UpdatedAtTimestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.GetSiteResponse.ReadOnly =
    zio.aws.iotroborunner.model.GetSiteResponse.wrap(buildAwsValue())
}
object GetSiteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.GetSiteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.GetSiteResponse =
      zio.aws.iotroborunner.model.GetSiteResponse(
        arn,
        id,
        name,
        countryCode,
        description.map(value => value),
        createdAt,
        updatedAt
      )
    def arn: SiteArn
    def id: SiteId
    def name: Name
    def countryCode: SiteCountryCode
    def description: Optional[SiteDescription]
    def createdAt: CreatedAtTimestamp
    def updatedAt: UpdatedAtTimestamp
    def getArn: ZIO[Any, Nothing, SiteArn] = ZIO.succeed(arn)
    def getId: ZIO[Any, Nothing, SiteId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getCountryCode: ZIO[Any, Nothing, SiteCountryCode] =
      ZIO.succeed(countryCode)
    def getDescription: ZIO[Any, AwsError, SiteDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAtTimestamp] =
      ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, UpdatedAtTimestamp] =
      ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetSiteResponse
  ) extends zio.aws.iotroborunner.model.GetSiteResponse.ReadOnly {
    override val arn: SiteArn =
      zio.aws.iotroborunner.model.primitives.SiteArn(impl.arn())
    override val id: SiteId =
      zio.aws.iotroborunner.model.primitives.SiteId(impl.id())
    override val name: Name =
      zio.aws.iotroborunner.model.primitives.Name(impl.name())
    override val countryCode: SiteCountryCode =
      zio.aws.iotroborunner.model.primitives.SiteCountryCode(impl.countryCode())
    override val description: Optional[SiteDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.SiteDescription(value)
      )
    override val createdAt: CreatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .CreatedAtTimestamp(impl.createdAt())
    override val updatedAt: UpdatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .UpdatedAtTimestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetSiteResponse
  ): zio.aws.iotroborunner.model.GetSiteResponse.ReadOnly = new Wrapper(impl)
}
