package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotroborunner.model.primitives.WorkerFleetGenericIdentifier
import scala.jdk.CollectionConverters.*
final case class GetWorkerFleetRequest(id: WorkerFleetGenericIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.GetWorkerFleetRequest = {
    import GetWorkerFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.GetWorkerFleetRequest
      .builder()
      .id(WorkerFleetGenericIdentifier.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.GetWorkerFleetRequest.ReadOnly =
    zio.aws.iotroborunner.model.GetWorkerFleetRequest.wrap(buildAwsValue())
}
object GetWorkerFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.GetWorkerFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.GetWorkerFleetRequest =
      zio.aws.iotroborunner.model.GetWorkerFleetRequest(id)
    def id: WorkerFleetGenericIdentifier
    def getId: ZIO[Any, Nothing, WorkerFleetGenericIdentifier] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetWorkerFleetRequest
  ) extends zio.aws.iotroborunner.model.GetWorkerFleetRequest.ReadOnly {
    override val id: WorkerFleetGenericIdentifier =
      zio.aws.iotroborunner.model.primitives
        .WorkerFleetGenericIdentifier(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetWorkerFleetRequest
  ): zio.aws.iotroborunner.model.GetWorkerFleetRequest.ReadOnly = new Wrapper(
    impl
  )
}
