package zio.aws.iotroborunner.model
import java.time.Instant
import zio.aws.iotroborunner.model.primitives.{
  SiteArn,
  WorkerFleetId,
  WorkerFleetArn,
  UpdatedAtTimestamp,
  WorkerFleetAdditionalFixedProperties,
  CreatedAtTimestamp,
  Name
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetWorkerFleetResponse(
    id: WorkerFleetId,
    arn: WorkerFleetArn,
    name: Name,
    site: SiteArn,
    createdAt: CreatedAtTimestamp,
    updatedAt: UpdatedAtTimestamp,
    additionalFixedProperties: Optional[WorkerFleetAdditionalFixedProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.GetWorkerFleetResponse = {
    import GetWorkerFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.GetWorkerFleetResponse
      .builder()
      .id(WorkerFleetId.unwrap(id): java.lang.String)
      .arn(WorkerFleetArn.unwrap(arn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .site(SiteArn.unwrap(site): java.lang.String)
      .createdAt(CreatedAtTimestamp.unwrap(createdAt): Instant)
      .updatedAt(UpdatedAtTimestamp.unwrap(updatedAt): Instant)
      .optionallyWith(
        additionalFixedProperties.map(value =>
          WorkerFleetAdditionalFixedProperties.unwrap(value): java.lang.String
        )
      )(_.additionalFixedProperties)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.GetWorkerFleetResponse.ReadOnly =
    zio.aws.iotroborunner.model.GetWorkerFleetResponse.wrap(buildAwsValue())
}
object GetWorkerFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.GetWorkerFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.GetWorkerFleetResponse =
      zio.aws.iotroborunner.model.GetWorkerFleetResponse(
        id,
        arn,
        name,
        site,
        createdAt,
        updatedAt,
        additionalFixedProperties.map(value => value)
      )
    def id: WorkerFleetId
    def arn: WorkerFleetArn
    def name: Name
    def site: SiteArn
    def createdAt: CreatedAtTimestamp
    def updatedAt: UpdatedAtTimestamp
    def additionalFixedProperties
        : Optional[WorkerFleetAdditionalFixedProperties]
    def getId: ZIO[Any, Nothing, WorkerFleetId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, WorkerFleetArn] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSite: ZIO[Any, Nothing, SiteArn] = ZIO.succeed(site)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAtTimestamp] =
      ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, UpdatedAtTimestamp] =
      ZIO.succeed(updatedAt)
    def getAdditionalFixedProperties
        : ZIO[Any, AwsError, WorkerFleetAdditionalFixedProperties] = AwsError
      .unwrapOptionField("additionalFixedProperties", additionalFixedProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetWorkerFleetResponse
  ) extends zio.aws.iotroborunner.model.GetWorkerFleetResponse.ReadOnly {
    override val id: WorkerFleetId =
      zio.aws.iotroborunner.model.primitives.WorkerFleetId(impl.id())
    override val arn: WorkerFleetArn =
      zio.aws.iotroborunner.model.primitives.WorkerFleetArn(impl.arn())
    override val name: Name =
      zio.aws.iotroborunner.model.primitives.Name(impl.name())
    override val site: SiteArn =
      zio.aws.iotroborunner.model.primitives.SiteArn(impl.site())
    override val createdAt: CreatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .CreatedAtTimestamp(impl.createdAt())
    override val updatedAt: UpdatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .UpdatedAtTimestamp(impl.updatedAt())
    override val additionalFixedProperties
        : Optional[WorkerFleetAdditionalFixedProperties] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalFixedProperties())
      .map(value =>
        zio.aws.iotroborunner.model.primitives
          .WorkerFleetAdditionalFixedProperties(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetWorkerFleetResponse
  ): zio.aws.iotroborunner.model.GetWorkerFleetResponse.ReadOnly = new Wrapper(
    impl
  )
}
