package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotroborunner.model.primitives.WorkerGenericIdentifier
import scala.jdk.CollectionConverters.*
final case class GetWorkerRequest(id: WorkerGenericIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.GetWorkerRequest = {
    import GetWorkerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.GetWorkerRequest
      .builder()
      .id(WorkerGenericIdentifier.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.GetWorkerRequest.ReadOnly =
    zio.aws.iotroborunner.model.GetWorkerRequest.wrap(buildAwsValue())
}
object GetWorkerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.GetWorkerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.GetWorkerRequest =
      zio.aws.iotroborunner.model.GetWorkerRequest(id)
    def id: WorkerGenericIdentifier
    def getId: ZIO[Any, Nothing, WorkerGenericIdentifier] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetWorkerRequest
  ) extends zio.aws.iotroborunner.model.GetWorkerRequest.ReadOnly {
    override val id: WorkerGenericIdentifier =
      zio.aws.iotroborunner.model.primitives.WorkerGenericIdentifier(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetWorkerRequest
  ): zio.aws.iotroborunner.model.GetWorkerRequest.ReadOnly = new Wrapper(impl)
}
