package zio.aws.iotroborunner.model
import java.time.Instant
import zio.aws.iotroborunner.model.primitives.{
  SiteArn,
  WorkerId,
  WorkerFleetArn,
  UpdatedAtTimestamp,
  WorkerAdditionalFixedPropertiesJson,
  CreatedAtTimestamp,
  WorkerArn,
  WorkerAdditionalTransientPropertiesJson,
  Name
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetWorkerResponse(
    arn: WorkerArn,
    id: WorkerId,
    fleet: WorkerFleetArn,
    site: SiteArn,
    createdAt: CreatedAtTimestamp,
    updatedAt: UpdatedAtTimestamp,
    name: Name,
    additionalTransientProperties: Optional[
      WorkerAdditionalTransientPropertiesJson
    ] = Optional.Absent,
    additionalFixedProperties: Optional[WorkerAdditionalFixedPropertiesJson] =
      Optional.Absent,
    vendorProperties: Optional[zio.aws.iotroborunner.model.VendorProperties] =
      Optional.Absent,
    position: Optional[zio.aws.iotroborunner.model.PositionCoordinates] =
      Optional.Absent,
    orientation: Optional[zio.aws.iotroborunner.model.Orientation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.GetWorkerResponse = {
    import GetWorkerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.GetWorkerResponse
      .builder()
      .arn(WorkerArn.unwrap(arn): java.lang.String)
      .id(WorkerId.unwrap(id): java.lang.String)
      .fleet(WorkerFleetArn.unwrap(fleet): java.lang.String)
      .site(SiteArn.unwrap(site): java.lang.String)
      .createdAt(CreatedAtTimestamp.unwrap(createdAt): Instant)
      .updatedAt(UpdatedAtTimestamp.unwrap(updatedAt): Instant)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        additionalTransientProperties.map(value =>
          WorkerAdditionalTransientPropertiesJson.unwrap(
            value
          ): java.lang.String
        )
      )(_.additionalTransientProperties)
      .optionallyWith(
        additionalFixedProperties.map(value =>
          WorkerAdditionalFixedPropertiesJson.unwrap(value): java.lang.String
        )
      )(_.additionalFixedProperties)
      .optionallyWith(vendorProperties.map(value => value.buildAwsValue()))(
        _.vendorProperties
      )
      .optionallyWith(position.map(value => value.buildAwsValue()))(_.position)
      .optionallyWith(orientation.map(value => value.buildAwsValue()))(
        _.orientation
      )
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.GetWorkerResponse.ReadOnly =
    zio.aws.iotroborunner.model.GetWorkerResponse.wrap(buildAwsValue())
}
object GetWorkerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.GetWorkerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.GetWorkerResponse =
      zio.aws.iotroborunner.model.GetWorkerResponse(
        arn,
        id,
        fleet,
        site,
        createdAt,
        updatedAt,
        name,
        additionalTransientProperties.map(value => value),
        additionalFixedProperties.map(value => value),
        vendorProperties.map(value => value.asEditable),
        position.map(value => value.asEditable),
        orientation.map(value => value.asEditable)
      )
    def arn: WorkerArn
    def id: WorkerId
    def fleet: WorkerFleetArn
    def site: SiteArn
    def createdAt: CreatedAtTimestamp
    def updatedAt: UpdatedAtTimestamp
    def name: Name
    def additionalTransientProperties
        : Optional[WorkerAdditionalTransientPropertiesJson]
    def additionalFixedProperties: Optional[WorkerAdditionalFixedPropertiesJson]
    def vendorProperties
        : Optional[zio.aws.iotroborunner.model.VendorProperties.ReadOnly]
    def position
        : Optional[zio.aws.iotroborunner.model.PositionCoordinates.ReadOnly]
    def orientation: Optional[zio.aws.iotroborunner.model.Orientation.ReadOnly]
    def getArn: ZIO[Any, Nothing, WorkerArn] = ZIO.succeed(arn)
    def getId: ZIO[Any, Nothing, WorkerId] = ZIO.succeed(id)
    def getFleet: ZIO[Any, Nothing, WorkerFleetArn] = ZIO.succeed(fleet)
    def getSite: ZIO[Any, Nothing, SiteArn] = ZIO.succeed(site)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAtTimestamp] =
      ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, UpdatedAtTimestamp] =
      ZIO.succeed(updatedAt)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getAdditionalTransientProperties
        : ZIO[Any, AwsError, WorkerAdditionalTransientPropertiesJson] =
      AwsError.unwrapOptionField(
        "additionalTransientProperties",
        additionalTransientProperties
      )
    def getAdditionalFixedProperties
        : ZIO[Any, AwsError, WorkerAdditionalFixedPropertiesJson] = AwsError
      .unwrapOptionField("additionalFixedProperties", additionalFixedProperties)
    def getVendorProperties: ZIO[
      Any,
      AwsError,
      zio.aws.iotroborunner.model.VendorProperties.ReadOnly
    ] = AwsError.unwrapOptionField("vendorProperties", vendorProperties)
    def getPosition: ZIO[
      Any,
      AwsError,
      zio.aws.iotroborunner.model.PositionCoordinates.ReadOnly
    ] = AwsError.unwrapOptionField("position", position)
    def getOrientation
        : ZIO[Any, AwsError, zio.aws.iotroborunner.model.Orientation.ReadOnly] =
      AwsError.unwrapOptionField("orientation", orientation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetWorkerResponse
  ) extends zio.aws.iotroborunner.model.GetWorkerResponse.ReadOnly {
    override val arn: WorkerArn =
      zio.aws.iotroborunner.model.primitives.WorkerArn(impl.arn())
    override val id: WorkerId =
      zio.aws.iotroborunner.model.primitives.WorkerId(impl.id())
    override val fleet: WorkerFleetArn =
      zio.aws.iotroborunner.model.primitives.WorkerFleetArn(impl.fleet())
    override val site: SiteArn =
      zio.aws.iotroborunner.model.primitives.SiteArn(impl.site())
    override val createdAt: CreatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .CreatedAtTimestamp(impl.createdAt())
    override val updatedAt: UpdatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .UpdatedAtTimestamp(impl.updatedAt())
    override val name: Name =
      zio.aws.iotroborunner.model.primitives.Name(impl.name())
    override val additionalTransientProperties
        : Optional[WorkerAdditionalTransientPropertiesJson] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalTransientProperties())
        .map(value =>
          zio.aws.iotroborunner.model.primitives
            .WorkerAdditionalTransientPropertiesJson(value)
        )
    override val additionalFixedProperties
        : Optional[WorkerAdditionalFixedPropertiesJson] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalFixedProperties())
      .map(value =>
        zio.aws.iotroborunner.model.primitives
          .WorkerAdditionalFixedPropertiesJson(value)
      )
    override val vendorProperties
        : Optional[zio.aws.iotroborunner.model.VendorProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorProperties())
        .map(value => zio.aws.iotroborunner.model.VendorProperties.wrap(value))
    override val position
        : Optional[zio.aws.iotroborunner.model.PositionCoordinates.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.position())
        .map(value =>
          zio.aws.iotroborunner.model.PositionCoordinates.wrap(value)
        )
    override val orientation
        : Optional[zio.aws.iotroborunner.model.Orientation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orientation())
        .map(value => zio.aws.iotroborunner.model.Orientation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetWorkerResponse
  ): zio.aws.iotroborunner.model.GetWorkerResponse.ReadOnly = new Wrapper(impl)
}
