package zio.aws.iotroborunner.model
import zio.aws.iotroborunner.model.primitives.{
  PaginationToken,
  PageSize,
  SiteGenericIdentifier
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDestinationsRequest(
    site: SiteGenericIdentifier,
    maxResults: Optional[PageSize] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    state: Optional[zio.aws.iotroborunner.model.DestinationState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.ListDestinationsRequest = {
    import ListDestinationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.ListDestinationsRequest
      .builder()
      .site(SiteGenericIdentifier.unwrap(site): java.lang.String)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.ListDestinationsRequest.ReadOnly =
    zio.aws.iotroborunner.model.ListDestinationsRequest.wrap(buildAwsValue())
}
object ListDestinationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.ListDestinationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.ListDestinationsRequest =
      zio.aws.iotroborunner.model.ListDestinationsRequest(
        site,
        maxResults.map(value => value),
        nextToken.map(value => value),
        state.map(value => value)
      )
    def site: SiteGenericIdentifier
    def maxResults: Optional[PageSize]
    def nextToken: Optional[PaginationToken]
    def state: Optional[zio.aws.iotroborunner.model.DestinationState]
    def getSite: ZIO[Any, Nothing, SiteGenericIdentifier] = ZIO.succeed(site)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getState
        : ZIO[Any, AwsError, zio.aws.iotroborunner.model.DestinationState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListDestinationsRequest
  ) extends zio.aws.iotroborunner.model.ListDestinationsRequest.ReadOnly {
    override val site: SiteGenericIdentifier =
      zio.aws.iotroborunner.model.primitives.SiteGenericIdentifier(impl.site())
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotroborunner.model.primitives.PageSize(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.PaginationToken(value)
      )
    override val state: Optional[zio.aws.iotroborunner.model.DestinationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.iotroborunner.model.DestinationState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListDestinationsRequest
  ): zio.aws.iotroborunner.model.ListDestinationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
