package zio.aws.iotroborunner.model
import zio.aws.iotroborunner.model.primitives.{
  PaginationToken,
  ListSitesPageSize
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSitesRequest(
    maxResults: Optional[ListSitesPageSize] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.ListSitesRequest = {
    import ListSitesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.ListSitesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => ListSitesPageSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.ListSitesRequest.ReadOnly =
    zio.aws.iotroborunner.model.ListSitesRequest.wrap(buildAwsValue())
}
object ListSitesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.ListSitesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.ListSitesRequest =
      zio.aws.iotroborunner.model.ListSitesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListSitesPageSize]
    def nextToken: Optional[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, ListSitesPageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListSitesRequest
  ) extends zio.aws.iotroborunner.model.ListSitesRequest.ReadOnly {
    override val maxResults: Optional[ListSitesPageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.ListSitesPageSize(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListSitesRequest
  ): zio.aws.iotroborunner.model.ListSitesRequest.ReadOnly = new Wrapper(impl)
}
