package zio.aws.iotroborunner.model
import zio.aws.iotroborunner.model.primitives.{
  PaginationToken,
  ListWorkerFleetsPageSize,
  SiteGenericIdentifier
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListWorkerFleetsRequest(
    site: SiteGenericIdentifier,
    maxResults: Optional[ListWorkerFleetsPageSize] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsRequest = {
    import ListWorkerFleetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsRequest
      .builder()
      .site(SiteGenericIdentifier.unwrap(site): java.lang.String)
      .optionallyWith(
        maxResults.map(value => ListWorkerFleetsPageSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.ListWorkerFleetsRequest.ReadOnly =
    zio.aws.iotroborunner.model.ListWorkerFleetsRequest.wrap(buildAwsValue())
}
object ListWorkerFleetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.ListWorkerFleetsRequest =
      zio.aws.iotroborunner.model.ListWorkerFleetsRequest(
        site,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def site: SiteGenericIdentifier
    def maxResults: Optional[ListWorkerFleetsPageSize]
    def nextToken: Optional[PaginationToken]
    def getSite: ZIO[Any, Nothing, SiteGenericIdentifier] = ZIO.succeed(site)
    def getMaxResults: ZIO[Any, AwsError, ListWorkerFleetsPageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsRequest
  ) extends zio.aws.iotroborunner.model.ListWorkerFleetsRequest.ReadOnly {
    override val site: SiteGenericIdentifier =
      zio.aws.iotroborunner.model.primitives.SiteGenericIdentifier(impl.site())
    override val maxResults: Optional[ListWorkerFleetsPageSize] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.iotroborunner.model.primitives.ListWorkerFleetsPageSize(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsRequest
  ): zio.aws.iotroborunner.model.ListWorkerFleetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
