package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotroborunner.model.primitives.{
  CreatedAtTimestamp,
  SiteCountryCode,
  Name,
  SiteArn
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Site(
    arn: SiteArn,
    name: Name,
    countryCode: SiteCountryCode,
    createdAt: CreatedAtTimestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.Site = {
    import Site.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.Site
      .builder()
      .arn(SiteArn.unwrap(arn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .countryCode(SiteCountryCode.unwrap(countryCode): java.lang.String)
      .createdAt(CreatedAtTimestamp.unwrap(createdAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.Site.ReadOnly =
    zio.aws.iotroborunner.model.Site.wrap(buildAwsValue())
}
object Site {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.Site
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.Site =
      zio.aws.iotroborunner.model.Site(arn, name, countryCode, createdAt)
    def arn: SiteArn
    def name: Name
    def countryCode: SiteCountryCode
    def createdAt: CreatedAtTimestamp
    def getArn: ZIO[Any, Nothing, SiteArn] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getCountryCode: ZIO[Any, Nothing, SiteCountryCode] =
      ZIO.succeed(countryCode)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAtTimestamp] =
      ZIO.succeed(createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.Site
  ) extends zio.aws.iotroborunner.model.Site.ReadOnly {
    override val arn: SiteArn =
      zio.aws.iotroborunner.model.primitives.SiteArn(impl.arn())
    override val name: Name =
      zio.aws.iotroborunner.model.primitives.Name(impl.name())
    override val countryCode: SiteCountryCode =
      zio.aws.iotroborunner.model.primitives.SiteCountryCode(impl.countryCode())
    override val createdAt: CreatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .CreatedAtTimestamp(impl.createdAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.Site
  ): zio.aws.iotroborunner.model.Site.ReadOnly = new Wrapper(impl)
}
