package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotroborunner.model.primitives.{
  DestinationAdditionalFixedProperties,
  Name,
  DestinationGenericIdentifier
}
import scala.jdk.CollectionConverters.*
final case class UpdateDestinationRequest(
    id: DestinationGenericIdentifier,
    name: Optional[Name] = Optional.Absent,
    state: Optional[zio.aws.iotroborunner.model.DestinationState] =
      Optional.Absent,
    additionalFixedProperties: Optional[DestinationAdditionalFixedProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.UpdateDestinationRequest = {
    import UpdateDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.UpdateDestinationRequest
      .builder()
      .id(DestinationGenericIdentifier.unwrap(id): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        additionalFixedProperties.map(value =>
          DestinationAdditionalFixedProperties.unwrap(value): java.lang.String
        )
      )(_.additionalFixedProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.iotroborunner.model.UpdateDestinationRequest.ReadOnly =
    zio.aws.iotroborunner.model.UpdateDestinationRequest.wrap(buildAwsValue())
}
object UpdateDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.UpdateDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.UpdateDestinationRequest =
      zio.aws.iotroborunner.model.UpdateDestinationRequest(
        id,
        name.map(value => value),
        state.map(value => value),
        additionalFixedProperties.map(value => value)
      )
    def id: DestinationGenericIdentifier
    def name: Optional[Name]
    def state: Optional[zio.aws.iotroborunner.model.DestinationState]
    def additionalFixedProperties
        : Optional[DestinationAdditionalFixedProperties]
    def getId: ZIO[Any, Nothing, DestinationGenericIdentifier] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getState
        : ZIO[Any, AwsError, zio.aws.iotroborunner.model.DestinationState] =
      AwsError.unwrapOptionField("state", state)
    def getAdditionalFixedProperties
        : ZIO[Any, AwsError, DestinationAdditionalFixedProperties] = AwsError
      .unwrapOptionField("additionalFixedProperties", additionalFixedProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateDestinationRequest
  ) extends zio.aws.iotroborunner.model.UpdateDestinationRequest.ReadOnly {
    override val id: DestinationGenericIdentifier =
      zio.aws.iotroborunner.model.primitives
        .DestinationGenericIdentifier(impl.id())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotroborunner.model.primitives.Name(value))
    override val state: Optional[zio.aws.iotroborunner.model.DestinationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.iotroborunner.model.DestinationState.wrap(value))
    override val additionalFixedProperties
        : Optional[DestinationAdditionalFixedProperties] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalFixedProperties())
      .map(value =>
        zio.aws.iotroborunner.model.primitives
          .DestinationAdditionalFixedProperties(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateDestinationRequest
  ): zio.aws.iotroborunner.model.UpdateDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
