package zio.aws.iotroborunner.model
import java.time.Instant
import zio.aws.iotroborunner.model.primitives.{
  DestinationId,
  DestinationAdditionalFixedProperties,
  UpdatedAtTimestamp,
  DestinationArn,
  Name
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateDestinationResponse(
    arn: DestinationArn,
    id: DestinationId,
    name: Name,
    updatedAt: UpdatedAtTimestamp,
    state: zio.aws.iotroborunner.model.DestinationState,
    additionalFixedProperties: Optional[DestinationAdditionalFixedProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.UpdateDestinationResponse = {
    import UpdateDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.UpdateDestinationResponse
      .builder()
      .arn(DestinationArn.unwrap(arn): java.lang.String)
      .id(DestinationId.unwrap(id): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .updatedAt(UpdatedAtTimestamp.unwrap(updatedAt): Instant)
      .state(state.unwrap)
      .optionallyWith(
        additionalFixedProperties.map(value =>
          DestinationAdditionalFixedProperties.unwrap(value): java.lang.String
        )
      )(_.additionalFixedProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.iotroborunner.model.UpdateDestinationResponse.ReadOnly =
    zio.aws.iotroborunner.model.UpdateDestinationResponse.wrap(buildAwsValue())
}
object UpdateDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.UpdateDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.UpdateDestinationResponse =
      zio.aws.iotroborunner.model.UpdateDestinationResponse(
        arn,
        id,
        name,
        updatedAt,
        state,
        additionalFixedProperties.map(value => value)
      )
    def arn: DestinationArn
    def id: DestinationId
    def name: Name
    def updatedAt: UpdatedAtTimestamp
    def state: zio.aws.iotroborunner.model.DestinationState
    def additionalFixedProperties
        : Optional[DestinationAdditionalFixedProperties]
    def getArn: ZIO[Any, Nothing, DestinationArn] = ZIO.succeed(arn)
    def getId: ZIO[Any, Nothing, DestinationId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getUpdatedAt: ZIO[Any, Nothing, UpdatedAtTimestamp] =
      ZIO.succeed(updatedAt)
    def getState
        : ZIO[Any, Nothing, zio.aws.iotroborunner.model.DestinationState] =
      ZIO.succeed(state)
    def getAdditionalFixedProperties
        : ZIO[Any, AwsError, DestinationAdditionalFixedProperties] = AwsError
      .unwrapOptionField("additionalFixedProperties", additionalFixedProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateDestinationResponse
  ) extends zio.aws.iotroborunner.model.UpdateDestinationResponse.ReadOnly {
    override val arn: DestinationArn =
      zio.aws.iotroborunner.model.primitives.DestinationArn(impl.arn())
    override val id: DestinationId =
      zio.aws.iotroborunner.model.primitives.DestinationId(impl.id())
    override val name: Name =
      zio.aws.iotroborunner.model.primitives.Name(impl.name())
    override val updatedAt: UpdatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .UpdatedAtTimestamp(impl.updatedAt())
    override val state: zio.aws.iotroborunner.model.DestinationState =
      zio.aws.iotroborunner.model.DestinationState.wrap(impl.state())
    override val additionalFixedProperties
        : Optional[DestinationAdditionalFixedProperties] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalFixedProperties())
      .map(value =>
        zio.aws.iotroborunner.model.primitives
          .DestinationAdditionalFixedProperties(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateDestinationResponse
  ): zio.aws.iotroborunner.model.UpdateDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
