package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotroborunner.model.primitives.{
  SiteDescription,
  SiteCountryCode,
  Name,
  SiteGenericIdentifier
}
import scala.jdk.CollectionConverters.*
final case class UpdateSiteRequest(
    id: SiteGenericIdentifier,
    name: Optional[Name] = Optional.Absent,
    countryCode: Optional[SiteCountryCode] = Optional.Absent,
    description: Optional[SiteDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.UpdateSiteRequest = {
    import UpdateSiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.UpdateSiteRequest
      .builder()
      .id(SiteGenericIdentifier.unwrap(id): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        countryCode.map(value =>
          SiteCountryCode.unwrap(value): java.lang.String
        )
      )(_.countryCode)
      .optionallyWith(
        description.map(value =>
          SiteDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.UpdateSiteRequest.ReadOnly =
    zio.aws.iotroborunner.model.UpdateSiteRequest.wrap(buildAwsValue())
}
object UpdateSiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.UpdateSiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.UpdateSiteRequest =
      zio.aws.iotroborunner.model.UpdateSiteRequest(
        id,
        name.map(value => value),
        countryCode.map(value => value),
        description.map(value => value)
      )
    def id: SiteGenericIdentifier
    def name: Optional[Name]
    def countryCode: Optional[SiteCountryCode]
    def description: Optional[SiteDescription]
    def getId: ZIO[Any, Nothing, SiteGenericIdentifier] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getCountryCode: ZIO[Any, AwsError, SiteCountryCode] =
      AwsError.unwrapOptionField("countryCode", countryCode)
    def getDescription: ZIO[Any, AwsError, SiteDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateSiteRequest
  ) extends zio.aws.iotroborunner.model.UpdateSiteRequest.ReadOnly {
    override val id: SiteGenericIdentifier =
      zio.aws.iotroborunner.model.primitives.SiteGenericIdentifier(impl.id())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotroborunner.model.primitives.Name(value))
    override val countryCode: Optional[SiteCountryCode] = zio.aws.core.internal
      .optionalFromNullable(impl.countryCode())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.SiteCountryCode(value)
      )
    override val description: Optional[SiteDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.SiteDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateSiteRequest
  ): zio.aws.iotroborunner.model.UpdateSiteRequest.ReadOnly = new Wrapper(impl)
}
