package zio.aws.iotroborunner.model
import java.time.Instant
import zio.aws.iotroborunner.model.primitives.{
  SiteArn,
  SiteCountryCode,
  SiteDescription,
  UpdatedAtTimestamp,
  SiteId,
  Name
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateSiteResponse(
    arn: SiteArn,
    id: SiteId,
    name: Name,
    countryCode: Optional[SiteCountryCode] = Optional.Absent,
    description: Optional[SiteDescription] = Optional.Absent,
    updatedAt: UpdatedAtTimestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.UpdateSiteResponse = {
    import UpdateSiteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.UpdateSiteResponse
      .builder()
      .arn(SiteArn.unwrap(arn): java.lang.String)
      .id(SiteId.unwrap(id): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        countryCode.map(value =>
          SiteCountryCode.unwrap(value): java.lang.String
        )
      )(_.countryCode)
      .optionallyWith(
        description.map(value =>
          SiteDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .updatedAt(UpdatedAtTimestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.UpdateSiteResponse.ReadOnly =
    zio.aws.iotroborunner.model.UpdateSiteResponse.wrap(buildAwsValue())
}
object UpdateSiteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.UpdateSiteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.UpdateSiteResponse =
      zio.aws.iotroborunner.model.UpdateSiteResponse(
        arn,
        id,
        name,
        countryCode.map(value => value),
        description.map(value => value),
        updatedAt
      )
    def arn: SiteArn
    def id: SiteId
    def name: Name
    def countryCode: Optional[SiteCountryCode]
    def description: Optional[SiteDescription]
    def updatedAt: UpdatedAtTimestamp
    def getArn: ZIO[Any, Nothing, SiteArn] = ZIO.succeed(arn)
    def getId: ZIO[Any, Nothing, SiteId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getCountryCode: ZIO[Any, AwsError, SiteCountryCode] =
      AwsError.unwrapOptionField("countryCode", countryCode)
    def getDescription: ZIO[Any, AwsError, SiteDescription] =
      AwsError.unwrapOptionField("description", description)
    def getUpdatedAt: ZIO[Any, Nothing, UpdatedAtTimestamp] =
      ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateSiteResponse
  ) extends zio.aws.iotroborunner.model.UpdateSiteResponse.ReadOnly {
    override val arn: SiteArn =
      zio.aws.iotroborunner.model.primitives.SiteArn(impl.arn())
    override val id: SiteId =
      zio.aws.iotroborunner.model.primitives.SiteId(impl.id())
    override val name: Name =
      zio.aws.iotroborunner.model.primitives.Name(impl.name())
    override val countryCode: Optional[SiteCountryCode] = zio.aws.core.internal
      .optionalFromNullable(impl.countryCode())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.SiteCountryCode(value)
      )
    override val description: Optional[SiteDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.SiteDescription(value)
      )
    override val updatedAt: UpdatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .UpdatedAtTimestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateSiteResponse
  ): zio.aws.iotroborunner.model.UpdateSiteResponse.ReadOnly = new Wrapper(impl)
}
