package zio.aws.iotroborunner.model
import java.time.Instant
import zio.aws.iotroborunner.model.primitives.{
  WorkerFleetId,
  WorkerFleetArn,
  UpdatedAtTimestamp,
  WorkerFleetAdditionalFixedProperties,
  Name
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateWorkerFleetResponse(
    arn: WorkerFleetArn,
    id: WorkerFleetId,
    name: Name,
    updatedAt: UpdatedAtTimestamp,
    additionalFixedProperties: Optional[WorkerFleetAdditionalFixedProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerFleetResponse = {
    import UpdateWorkerFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerFleetResponse
      .builder()
      .arn(WorkerFleetArn.unwrap(arn): java.lang.String)
      .id(WorkerFleetId.unwrap(id): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .updatedAt(UpdatedAtTimestamp.unwrap(updatedAt): Instant)
      .optionallyWith(
        additionalFixedProperties.map(value =>
          WorkerFleetAdditionalFixedProperties.unwrap(value): java.lang.String
        )
      )(_.additionalFixedProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.iotroborunner.model.UpdateWorkerFleetResponse.ReadOnly =
    zio.aws.iotroborunner.model.UpdateWorkerFleetResponse.wrap(buildAwsValue())
}
object UpdateWorkerFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.UpdateWorkerFleetResponse =
      zio.aws.iotroborunner.model.UpdateWorkerFleetResponse(
        arn,
        id,
        name,
        updatedAt,
        additionalFixedProperties.map(value => value)
      )
    def arn: WorkerFleetArn
    def id: WorkerFleetId
    def name: Name
    def updatedAt: UpdatedAtTimestamp
    def additionalFixedProperties
        : Optional[WorkerFleetAdditionalFixedProperties]
    def getArn: ZIO[Any, Nothing, WorkerFleetArn] = ZIO.succeed(arn)
    def getId: ZIO[Any, Nothing, WorkerFleetId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getUpdatedAt: ZIO[Any, Nothing, UpdatedAtTimestamp] =
      ZIO.succeed(updatedAt)
    def getAdditionalFixedProperties
        : ZIO[Any, AwsError, WorkerFleetAdditionalFixedProperties] = AwsError
      .unwrapOptionField("additionalFixedProperties", additionalFixedProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerFleetResponse
  ) extends zio.aws.iotroborunner.model.UpdateWorkerFleetResponse.ReadOnly {
    override val arn: WorkerFleetArn =
      zio.aws.iotroborunner.model.primitives.WorkerFleetArn(impl.arn())
    override val id: WorkerFleetId =
      zio.aws.iotroborunner.model.primitives.WorkerFleetId(impl.id())
    override val name: Name =
      zio.aws.iotroborunner.model.primitives.Name(impl.name())
    override val updatedAt: UpdatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .UpdatedAtTimestamp(impl.updatedAt())
    override val additionalFixedProperties
        : Optional[WorkerFleetAdditionalFixedProperties] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalFixedProperties())
      .map(value =>
        zio.aws.iotroborunner.model.primitives
          .WorkerFleetAdditionalFixedProperties(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerFleetResponse
  ): zio.aws.iotroborunner.model.UpdateWorkerFleetResponse.ReadOnly =
    new Wrapper(impl)
}
