package zio.aws.iotroborunner.model
import java.time.Instant
import zio.aws.iotroborunner.model.primitives.{
  WorkerId,
  WorkerFleetArn,
  UpdatedAtTimestamp,
  WorkerAdditionalFixedPropertiesJson,
  WorkerArn,
  WorkerAdditionalTransientPropertiesJson,
  Name
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateWorkerResponse(
    arn: WorkerArn,
    id: WorkerId,
    fleet: WorkerFleetArn,
    updatedAt: UpdatedAtTimestamp,
    name: Name,
    additionalTransientProperties: Optional[
      WorkerAdditionalTransientPropertiesJson
    ] = Optional.Absent,
    additionalFixedProperties: Optional[WorkerAdditionalFixedPropertiesJson] =
      Optional.Absent,
    orientation: Optional[zio.aws.iotroborunner.model.Orientation] =
      Optional.Absent,
    vendorProperties: Optional[zio.aws.iotroborunner.model.VendorProperties] =
      Optional.Absent,
    position: Optional[zio.aws.iotroborunner.model.PositionCoordinates] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerResponse = {
    import UpdateWorkerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerResponse
      .builder()
      .arn(WorkerArn.unwrap(arn): java.lang.String)
      .id(WorkerId.unwrap(id): java.lang.String)
      .fleet(WorkerFleetArn.unwrap(fleet): java.lang.String)
      .updatedAt(UpdatedAtTimestamp.unwrap(updatedAt): Instant)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        additionalTransientProperties.map(value =>
          WorkerAdditionalTransientPropertiesJson.unwrap(
            value
          ): java.lang.String
        )
      )(_.additionalTransientProperties)
      .optionallyWith(
        additionalFixedProperties.map(value =>
          WorkerAdditionalFixedPropertiesJson.unwrap(value): java.lang.String
        )
      )(_.additionalFixedProperties)
      .optionallyWith(orientation.map(value => value.buildAwsValue()))(
        _.orientation
      )
      .optionallyWith(vendorProperties.map(value => value.buildAwsValue()))(
        _.vendorProperties
      )
      .optionallyWith(position.map(value => value.buildAwsValue()))(_.position)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.UpdateWorkerResponse.ReadOnly =
    zio.aws.iotroborunner.model.UpdateWorkerResponse.wrap(buildAwsValue())
}
object UpdateWorkerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.UpdateWorkerResponse =
      zio.aws.iotroborunner.model.UpdateWorkerResponse(
        arn,
        id,
        fleet,
        updatedAt,
        name,
        additionalTransientProperties.map(value => value),
        additionalFixedProperties.map(value => value),
        orientation.map(value => value.asEditable),
        vendorProperties.map(value => value.asEditable),
        position.map(value => value.asEditable)
      )
    def arn: WorkerArn
    def id: WorkerId
    def fleet: WorkerFleetArn
    def updatedAt: UpdatedAtTimestamp
    def name: Name
    def additionalTransientProperties
        : Optional[WorkerAdditionalTransientPropertiesJson]
    def additionalFixedProperties: Optional[WorkerAdditionalFixedPropertiesJson]
    def orientation: Optional[zio.aws.iotroborunner.model.Orientation.ReadOnly]
    def vendorProperties
        : Optional[zio.aws.iotroborunner.model.VendorProperties.ReadOnly]
    def position
        : Optional[zio.aws.iotroborunner.model.PositionCoordinates.ReadOnly]
    def getArn: ZIO[Any, Nothing, WorkerArn] = ZIO.succeed(arn)
    def getId: ZIO[Any, Nothing, WorkerId] = ZIO.succeed(id)
    def getFleet: ZIO[Any, Nothing, WorkerFleetArn] = ZIO.succeed(fleet)
    def getUpdatedAt: ZIO[Any, Nothing, UpdatedAtTimestamp] =
      ZIO.succeed(updatedAt)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getAdditionalTransientProperties
        : ZIO[Any, AwsError, WorkerAdditionalTransientPropertiesJson] =
      AwsError.unwrapOptionField(
        "additionalTransientProperties",
        additionalTransientProperties
      )
    def getAdditionalFixedProperties
        : ZIO[Any, AwsError, WorkerAdditionalFixedPropertiesJson] = AwsError
      .unwrapOptionField("additionalFixedProperties", additionalFixedProperties)
    def getOrientation
        : ZIO[Any, AwsError, zio.aws.iotroborunner.model.Orientation.ReadOnly] =
      AwsError.unwrapOptionField("orientation", orientation)
    def getVendorProperties: ZIO[
      Any,
      AwsError,
      zio.aws.iotroborunner.model.VendorProperties.ReadOnly
    ] = AwsError.unwrapOptionField("vendorProperties", vendorProperties)
    def getPosition: ZIO[
      Any,
      AwsError,
      zio.aws.iotroborunner.model.PositionCoordinates.ReadOnly
    ] = AwsError.unwrapOptionField("position", position)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerResponse
  ) extends zio.aws.iotroborunner.model.UpdateWorkerResponse.ReadOnly {
    override val arn: WorkerArn =
      zio.aws.iotroborunner.model.primitives.WorkerArn(impl.arn())
    override val id: WorkerId =
      zio.aws.iotroborunner.model.primitives.WorkerId(impl.id())
    override val fleet: WorkerFleetArn =
      zio.aws.iotroborunner.model.primitives.WorkerFleetArn(impl.fleet())
    override val updatedAt: UpdatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .UpdatedAtTimestamp(impl.updatedAt())
    override val name: Name =
      zio.aws.iotroborunner.model.primitives.Name(impl.name())
    override val additionalTransientProperties
        : Optional[WorkerAdditionalTransientPropertiesJson] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalTransientProperties())
        .map(value =>
          zio.aws.iotroborunner.model.primitives
            .WorkerAdditionalTransientPropertiesJson(value)
        )
    override val additionalFixedProperties
        : Optional[WorkerAdditionalFixedPropertiesJson] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalFixedProperties())
      .map(value =>
        zio.aws.iotroborunner.model.primitives
          .WorkerAdditionalFixedPropertiesJson(value)
      )
    override val orientation
        : Optional[zio.aws.iotroborunner.model.Orientation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orientation())
        .map(value => zio.aws.iotroborunner.model.Orientation.wrap(value))
    override val vendorProperties
        : Optional[zio.aws.iotroborunner.model.VendorProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorProperties())
        .map(value => zio.aws.iotroborunner.model.VendorProperties.wrap(value))
    override val position
        : Optional[zio.aws.iotroborunner.model.PositionCoordinates.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.position())
        .map(value =>
          zio.aws.iotroborunner.model.PositionCoordinates.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerResponse
  ): zio.aws.iotroborunner.model.UpdateWorkerResponse.ReadOnly = new Wrapper(
    impl
  )
}
