package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait AggregateType {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.AggregateType
}
object AggregateType {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.AggregateType
  ): zio.aws.iotsitewise.model.AggregateType = value match {
    case software.amazon.awssdk.services.iotsitewise.model.AggregateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.AggregateType.AVERAGE =>
      val r = AVERAGE
      r
    case software.amazon.awssdk.services.iotsitewise.model.AggregateType.COUNT =>
      val r = COUNT
      r
    case software.amazon.awssdk.services.iotsitewise.model.AggregateType.MAXIMUM =>
      val r = MAXIMUM
      r
    case software.amazon.awssdk.services.iotsitewise.model.AggregateType.MINIMUM =>
      val r = MINIMUM
      r
    case software.amazon.awssdk.services.iotsitewise.model.AggregateType.SUM =>
      val r = SUM
      r
    case software.amazon.awssdk.services.iotsitewise.model.AggregateType.STANDARD_DEVIATION =>
      val r = STANDARD_DEVIATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.AggregateType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AggregateType =
      software.amazon.awssdk.services.iotsitewise.model.AggregateType.UNKNOWN_TO_SDK_VERSION
  }
  case object AVERAGE extends zio.aws.iotsitewise.model.AggregateType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AggregateType =
      software.amazon.awssdk.services.iotsitewise.model.AggregateType.AVERAGE
  }
  case object COUNT extends zio.aws.iotsitewise.model.AggregateType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AggregateType =
      software.amazon.awssdk.services.iotsitewise.model.AggregateType.COUNT
  }
  case object MAXIMUM extends zio.aws.iotsitewise.model.AggregateType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AggregateType =
      software.amazon.awssdk.services.iotsitewise.model.AggregateType.MAXIMUM
  }
  case object MINIMUM extends zio.aws.iotsitewise.model.AggregateType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AggregateType =
      software.amazon.awssdk.services.iotsitewise.model.AggregateType.MINIMUM
  }
  case object SUM extends zio.aws.iotsitewise.model.AggregateType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AggregateType =
      software.amazon.awssdk.services.iotsitewise.model.AggregateType.SUM
  }
  case object STANDARD_DEVIATION
      extends zio.aws.iotsitewise.model.AggregateType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AggregateType =
      software.amazon.awssdk.services.iotsitewise.model.AggregateType.STANDARD_DEVIATION
  }
}
