package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Description, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssetCompositeModel(
    name: Name,
    description: Optional[Description] = Optional.Absent,
    `type`: Name,
    properties: Iterable[zio.aws.iotsitewise.model.AssetProperty]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModel = {
    import AssetCompositeModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModel
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .`type`(Name.unwrap(`type`): java.lang.String)
      .properties(properties.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetCompositeModel.ReadOnly =
    zio.aws.iotsitewise.model.AssetCompositeModel.wrap(buildAwsValue())
}
object AssetCompositeModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetCompositeModel =
      zio.aws.iotsitewise.model.AssetCompositeModel(
        name,
        description.map(value => value),
        `type`,
        properties.map { item =>
          item.asEditable
        }
      )
    def name: Name
    def description: Optional[Description]
    def `type`: Name
    def properties: List[zio.aws.iotsitewise.model.AssetProperty.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, Nothing, Name] = ZIO.succeed(`type`)
    def getProperties: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AssetProperty.ReadOnly
    ]] = ZIO.succeed(properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModel
  ) extends zio.aws.iotsitewise.model.AssetCompositeModel.ReadOnly {
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val `type`: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.`type`())
    override val properties
        : List[zio.aws.iotsitewise.model.AssetProperty.ReadOnly] = impl
      .properties()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.AssetProperty.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModel
  ): zio.aws.iotsitewise.model.AssetCompositeModel.ReadOnly = new Wrapper(impl)
}
