package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait AssetState {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.AssetState
}
object AssetState {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.AssetState
  ): zio.aws.iotsitewise.model.AssetState = value match {
    case software.amazon.awssdk.services.iotsitewise.model.AssetState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.AssetState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.iotsitewise.model.AssetState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.iotsitewise.model.AssetState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.iotsitewise.model.AssetState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.iotsitewise.model.AssetState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.iotsitewise.model.AssetState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AssetState =
      software.amazon.awssdk.services.iotsitewise.model.AssetState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.iotsitewise.model.AssetState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AssetState =
      software.amazon.awssdk.services.iotsitewise.model.AssetState.CREATING
  }
  case object ACTIVE extends zio.aws.iotsitewise.model.AssetState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AssetState =
      software.amazon.awssdk.services.iotsitewise.model.AssetState.ACTIVE
  }
  case object UPDATING extends zio.aws.iotsitewise.model.AssetState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AssetState =
      software.amazon.awssdk.services.iotsitewise.model.AssetState.UPDATING
  }
  case object DELETING extends zio.aws.iotsitewise.model.AssetState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AssetState =
      software.amazon.awssdk.services.iotsitewise.model.AssetState.DELETING
  }
  case object FAILED extends zio.aws.iotsitewise.model.AssetState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AssetState =
      software.amazon.awssdk.services.iotsitewise.model.AssetState.FAILED
  }
}
