package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait BatchPutAssetPropertyValueErrorCode {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode
}
object BatchPutAssetPropertyValueErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode
  ): zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode =
    value match {
      case software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.RESOURCE_NOT_FOUND_EXCEPTION =>
        val r = ResourceNotFoundException
        r
      case software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.INVALID_REQUEST_EXCEPTION =>
        val r = InvalidRequestException
        r
      case software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.INTERNAL_FAILURE_EXCEPTION =>
        val r = InternalFailureException
        r
      case software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.SERVICE_UNAVAILABLE_EXCEPTION =>
        val r = ServiceUnavailableException
        r
      case software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.THROTTLING_EXCEPTION =>
        val r = ThrottlingException
        r
      case software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.LIMIT_EXCEEDED_EXCEPTION =>
        val r = LimitExceededException
        r
      case software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.CONFLICTING_OPERATION_EXCEPTION =>
        val r = ConflictingOperationException
        r
      case software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.TIMESTAMP_OUT_OF_RANGE_EXCEPTION =>
        val r = TimestampOutOfRangeException
        r
      case software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.ACCESS_DENIED_EXCEPTION =>
        val r = AccessDeniedException
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ResourceNotFoundException
      extends zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.RESOURCE_NOT_FOUND_EXCEPTION
  }
  case object InvalidRequestException
      extends zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.INVALID_REQUEST_EXCEPTION
  }
  case object InternalFailureException
      extends zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.INTERNAL_FAILURE_EXCEPTION
  }
  case object ServiceUnavailableException
      extends zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.SERVICE_UNAVAILABLE_EXCEPTION
  }
  case object ThrottlingException
      extends zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.THROTTLING_EXCEPTION
  }
  case object LimitExceededException
      extends zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.LIMIT_EXCEEDED_EXCEPTION
  }
  case object ConflictingOperationException
      extends zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.CONFLICTING_OPERATION_EXCEPTION
  }
  case object TimestampOutOfRangeException
      extends zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.TIMESTAMP_OUT_OF_RANGE_EXCEPTION
  }
  case object AccessDeniedException
      extends zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode.ACCESS_DENIED_EXCEPTION
  }
}
