package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ARN, ID}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateAccessPolicyResponse(
    accessPolicyId: ID,
    accessPolicyArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyResponse = {
    import CreateAccessPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyResponse
      .builder()
      .accessPolicyId(ID.unwrap(accessPolicyId): java.lang.String)
      .accessPolicyArn(ARN.unwrap(accessPolicyArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.CreateAccessPolicyResponse.ReadOnly =
    zio.aws.iotsitewise.model.CreateAccessPolicyResponse.wrap(buildAwsValue())
}
object CreateAccessPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreateAccessPolicyResponse =
      zio.aws.iotsitewise.model
        .CreateAccessPolicyResponse(accessPolicyId, accessPolicyArn)
    def accessPolicyId: ID
    def accessPolicyArn: ARN
    def getAccessPolicyId: ZIO[Any, Nothing, ID] = ZIO.succeed(accessPolicyId)
    def getAccessPolicyArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(accessPolicyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyResponse
  ) extends zio.aws.iotsitewise.model.CreateAccessPolicyResponse.ReadOnly {
    override val accessPolicyId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.accessPolicyId())
    override val accessPolicyArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.accessPolicyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyResponse
  ): zio.aws.iotsitewise.model.CreateAccessPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
