package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  TagValue,
  ClientToken,
  Name,
  ID,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAssetRequest(
    assetName: Name,
    assetModelId: ID,
    clientToken: Optional[ClientToken] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreateAssetRequest = {
    import CreateAssetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreateAssetRequest
      .builder()
      .assetName(Name.unwrap(assetName): java.lang.String)
      .assetModelId(ID.unwrap(assetModelId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CreateAssetRequest.ReadOnly =
    zio.aws.iotsitewise.model.CreateAssetRequest.wrap(buildAwsValue())
}
object CreateAssetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreateAssetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreateAssetRequest =
      zio.aws.iotsitewise.model.CreateAssetRequest(
        assetName,
        assetModelId,
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def assetName: Name
    def assetModelId: ID
    def clientToken: Optional[ClientToken]
    def tags: Optional[Map[TagKey, TagValue]]
    def getAssetName: ZIO[Any, Nothing, Name] = ZIO.succeed(assetName)
    def getAssetModelId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetModelId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateAssetRequest
  ) extends zio.aws.iotsitewise.model.CreateAssetRequest.ReadOnly {
    override val assetName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.assetName())
    override val assetModelId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetModelId())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotsitewise.model.primitives.TagKey(
              key
            ) -> zio.aws.iotsitewise.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateAssetRequest
  ): zio.aws.iotsitewise.model.CreateAssetRequest.ReadOnly = new Wrapper(impl)
}
