package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ARN, ID}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateDashboardResponse(dashboardId: ID, dashboardArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreateDashboardResponse = {
    import CreateDashboardResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreateDashboardResponse
      .builder()
      .dashboardId(ID.unwrap(dashboardId): java.lang.String)
      .dashboardArn(ARN.unwrap(dashboardArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CreateDashboardResponse.ReadOnly =
    zio.aws.iotsitewise.model.CreateDashboardResponse.wrap(buildAwsValue())
}
object CreateDashboardResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreateDashboardResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreateDashboardResponse =
      zio.aws.iotsitewise.model
        .CreateDashboardResponse(dashboardId, dashboardArn)
    def dashboardId: ID
    def dashboardArn: ARN
    def getDashboardId: ZIO[Any, Nothing, ID] = ZIO.succeed(dashboardId)
    def getDashboardArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(dashboardArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateDashboardResponse
  ) extends zio.aws.iotsitewise.model.CreateDashboardResponse.ReadOnly {
    override val dashboardId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.dashboardId())
    override val dashboardArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.dashboardArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateDashboardResponse
  ): zio.aws.iotsitewise.model.CreateDashboardResponse.ReadOnly = new Wrapper(
    impl
  )
}
