package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{TagValue, TagKey, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateGatewayRequest(
    gatewayName: Name,
    gatewayPlatform: zio.aws.iotsitewise.model.GatewayPlatform,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreateGatewayRequest = {
    import CreateGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreateGatewayRequest
      .builder()
      .gatewayName(Name.unwrap(gatewayName): java.lang.String)
      .gatewayPlatform(gatewayPlatform.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CreateGatewayRequest.ReadOnly =
    zio.aws.iotsitewise.model.CreateGatewayRequest.wrap(buildAwsValue())
}
object CreateGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreateGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreateGatewayRequest =
      zio.aws.iotsitewise.model.CreateGatewayRequest(
        gatewayName,
        gatewayPlatform.asEditable,
        tags.map(value => value)
      )
    def gatewayName: Name
    def gatewayPlatform: zio.aws.iotsitewise.model.GatewayPlatform.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def getGatewayName: ZIO[Any, Nothing, Name] = ZIO.succeed(gatewayName)
    def getGatewayPlatform: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.GatewayPlatform.ReadOnly
    ] = ZIO.succeed(gatewayPlatform)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateGatewayRequest
  ) extends zio.aws.iotsitewise.model.CreateGatewayRequest.ReadOnly {
    override val gatewayName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.gatewayName())
    override val gatewayPlatform
        : zio.aws.iotsitewise.model.GatewayPlatform.ReadOnly =
      zio.aws.iotsitewise.model.GatewayPlatform.wrap(impl.gatewayPlatform())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotsitewise.model.primitives.TagKey(
              key
            ) -> zio.aws.iotsitewise.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateGatewayRequest
  ): zio.aws.iotsitewise.model.CreateGatewayRequest.ReadOnly = new Wrapper(impl)
}
