package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{SSOApplicationId, Url, ARN, ID}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreatePortalResponse(
    portalId: ID,
    portalArn: ARN,
    portalStartUrl: Url,
    portalStatus: zio.aws.iotsitewise.model.PortalStatus,
    ssoApplicationId: SSOApplicationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreatePortalResponse = {
    import CreatePortalResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreatePortalResponse
      .builder()
      .portalId(ID.unwrap(portalId): java.lang.String)
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .portalStartUrl(Url.unwrap(portalStartUrl): java.lang.String)
      .portalStatus(portalStatus.buildAwsValue())
      .ssoApplicationId(
        SSOApplicationId.unwrap(ssoApplicationId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CreatePortalResponse.ReadOnly =
    zio.aws.iotsitewise.model.CreatePortalResponse.wrap(buildAwsValue())
}
object CreatePortalResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreatePortalResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreatePortalResponse =
      zio.aws.iotsitewise.model.CreatePortalResponse(
        portalId,
        portalArn,
        portalStartUrl,
        portalStatus.asEditable,
        ssoApplicationId
      )
    def portalId: ID
    def portalArn: ARN
    def portalStartUrl: Url
    def portalStatus: zio.aws.iotsitewise.model.PortalStatus.ReadOnly
    def ssoApplicationId: SSOApplicationId
    def getPortalId: ZIO[Any, Nothing, ID] = ZIO.succeed(portalId)
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
    def getPortalStartUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(portalStartUrl)
    def getPortalStatus
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.PortalStatus.ReadOnly] =
      ZIO.succeed(portalStatus)
    def getSsoApplicationId: ZIO[Any, Nothing, SSOApplicationId] =
      ZIO.succeed(ssoApplicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreatePortalResponse
  ) extends zio.aws.iotsitewise.model.CreatePortalResponse.ReadOnly {
    override val portalId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.portalId())
    override val portalArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.portalArn())
    override val portalStartUrl: Url =
      zio.aws.iotsitewise.model.primitives.Url(impl.portalStartUrl())
    override val portalStatus: zio.aws.iotsitewise.model.PortalStatus.ReadOnly =
      zio.aws.iotsitewise.model.PortalStatus.wrap(impl.portalStatus())
    override val ssoApplicationId: SSOApplicationId =
      zio.aws.iotsitewise.model.primitives
        .SSOApplicationId(impl.ssoApplicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreatePortalResponse
  ): zio.aws.iotsitewise.model.CreatePortalResponse.ReadOnly = new Wrapper(impl)
}
