package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CustomerManagedS3Storage(s3ResourceArn: ARN, roleArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CustomerManagedS3Storage = {
    import CustomerManagedS3Storage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CustomerManagedS3Storage
      .builder()
      .s3ResourceArn(ARN.unwrap(s3ResourceArn): java.lang.String)
      .roleArn(ARN.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CustomerManagedS3Storage.ReadOnly =
    zio.aws.iotsitewise.model.CustomerManagedS3Storage.wrap(buildAwsValue())
}
object CustomerManagedS3Storage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CustomerManagedS3Storage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CustomerManagedS3Storage =
      zio.aws.iotsitewise.model.CustomerManagedS3Storage(s3ResourceArn, roleArn)
    def s3ResourceArn: ARN
    def roleArn: ARN
    def getS3ResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(s3ResourceArn)
    def getRoleArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CustomerManagedS3Storage
  ) extends zio.aws.iotsitewise.model.CustomerManagedS3Storage.ReadOnly {
    override val s3ResourceArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.s3ResourceArn())
    override val roleArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CustomerManagedS3Storage
  ): zio.aws.iotsitewise.model.CustomerManagedS3Storage.ReadOnly = new Wrapper(
    impl
  )
}
