package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeAssetModelRequest(assetModelId: ID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest = {
    import DescribeAssetModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest
      .builder()
      .assetModelId(ID.unwrap(assetModelId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DescribeAssetModelRequest.ReadOnly =
    zio.aws.iotsitewise.model.DescribeAssetModelRequest.wrap(buildAwsValue())
}
object DescribeAssetModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeAssetModelRequest =
      zio.aws.iotsitewise.model.DescribeAssetModelRequest(assetModelId)
    def assetModelId: ID
    def getAssetModelId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetModelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest
  ) extends zio.aws.iotsitewise.model.DescribeAssetModelRequest.ReadOnly {
    override val assetModelId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetModelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest
  ): zio.aws.iotsitewise.model.DescribeAssetModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
