package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeAssetPropertyRequest(assetId: ID, propertyId: ID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyRequest = {
    import DescribeAssetPropertyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyRequest
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .propertyId(ID.unwrap(propertyId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.DescribeAssetPropertyRequest.ReadOnly =
    zio.aws.iotsitewise.model.DescribeAssetPropertyRequest.wrap(buildAwsValue())
}
object DescribeAssetPropertyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeAssetPropertyRequest =
      zio.aws.iotsitewise.model
        .DescribeAssetPropertyRequest(assetId, propertyId)
    def assetId: ID
    def propertyId: ID
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getPropertyId: ZIO[Any, Nothing, ID] = ZIO.succeed(propertyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyRequest
  ) extends zio.aws.iotsitewise.model.DescribeAssetPropertyRequest.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val propertyId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.propertyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyRequest
  ): zio.aws.iotsitewise.model.DescribeAssetPropertyRequest.ReadOnly =
    new Wrapper(impl)
}
