package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeAssetRequest(assetId: ID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest = {
    import DescribeAssetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DescribeAssetRequest.ReadOnly =
    zio.aws.iotsitewise.model.DescribeAssetRequest.wrap(buildAwsValue())
}
object DescribeAssetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeAssetRequest =
      zio.aws.iotsitewise.model.DescribeAssetRequest(assetId)
    def assetId: ID
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest
  ) extends zio.aws.iotsitewise.model.DescribeAssetRequest.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest
  ): zio.aws.iotsitewise.model.DescribeAssetRequest.ReadOnly = new Wrapper(impl)
}
