package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  CapabilityConfiguration,
  CapabilityNamespace,
  ID
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeGatewayCapabilityConfigurationResponse(
    gatewayId: ID,
    capabilityNamespace: CapabilityNamespace,
    capabilityConfiguration: CapabilityConfiguration,
    capabilitySyncStatus: zio.aws.iotsitewise.model.CapabilitySyncStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse = {
    import DescribeGatewayCapabilityConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse
      .builder()
      .gatewayId(ID.unwrap(gatewayId): java.lang.String)
      .capabilityNamespace(
        CapabilityNamespace.unwrap(capabilityNamespace): java.lang.String
      )
      .capabilityConfiguration(
        CapabilityConfiguration.unwrap(
          capabilityConfiguration
        ): java.lang.String
      )
      .capabilitySyncStatus(capabilitySyncStatus.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse.ReadOnly =
    zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeGatewayCapabilityConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse =
      zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse(
        gatewayId,
        capabilityNamespace,
        capabilityConfiguration,
        capabilitySyncStatus
      )
    def gatewayId: ID
    def capabilityNamespace: CapabilityNamespace
    def capabilityConfiguration: CapabilityConfiguration
    def capabilitySyncStatus: zio.aws.iotsitewise.model.CapabilitySyncStatus
    def getGatewayId: ZIO[Any, Nothing, ID] = ZIO.succeed(gatewayId)
    def getCapabilityNamespace: ZIO[Any, Nothing, CapabilityNamespace] =
      ZIO.succeed(capabilityNamespace)
    def getCapabilityConfiguration: ZIO[Any, Nothing, CapabilityConfiguration] =
      ZIO.succeed(capabilityConfiguration)
    def getCapabilitySyncStatus
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.CapabilitySyncStatus] =
      ZIO.succeed(capabilitySyncStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse
  ) extends zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse.ReadOnly {
    override val gatewayId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.gatewayId())
    override val capabilityNamespace: CapabilityNamespace =
      zio.aws.iotsitewise.model.primitives
        .CapabilityNamespace(impl.capabilityNamespace())
    override val capabilityConfiguration: CapabilityConfiguration =
      zio.aws.iotsitewise.model.primitives
        .CapabilityConfiguration(impl.capabilityConfiguration())
    override val capabilitySyncStatus
        : zio.aws.iotsitewise.model.CapabilitySyncStatus =
      zio.aws.iotsitewise.model.CapabilitySyncStatus
        .wrap(impl.capabilitySyncStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse
  ): zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
