package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeGatewayRequest(gatewayId: ID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayRequest = {
    import DescribeGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayRequest
      .builder()
      .gatewayId(ID.unwrap(gatewayId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DescribeGatewayRequest.ReadOnly =
    zio.aws.iotsitewise.model.DescribeGatewayRequest.wrap(buildAwsValue())
}
object DescribeGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeGatewayRequest =
      zio.aws.iotsitewise.model.DescribeGatewayRequest(gatewayId)
    def gatewayId: ID
    def getGatewayId: ZIO[Any, Nothing, ID] = ZIO.succeed(gatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayRequest
  ) extends zio.aws.iotsitewise.model.DescribeGatewayRequest.ReadOnly {
    override val gatewayId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.gatewayId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayRequest
  ): zio.aws.iotsitewise.model.DescribeGatewayRequest.ReadOnly = new Wrapper(
    impl
  )
}
