package zio.aws.iotsitewise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{
  TimeSeriesId,
  Timestamp,
  PropertyAlias,
  Name,
  ID
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeTimeSeriesResponse(
    assetId: Optional[ID] = Optional.Absent,
    propertyId: Optional[ID] = Optional.Absent,
    alias: Optional[PropertyAlias] = Optional.Absent,
    timeSeriesId: TimeSeriesId,
    dataType: zio.aws.iotsitewise.model.PropertyDataType,
    dataTypeSpec: Optional[Name] = Optional.Absent,
    timeSeriesCreationDate: Timestamp,
    timeSeriesLastUpdateDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesResponse = {
    import DescribeTimeSeriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesResponse
      .builder()
      .optionallyWith(assetId.map(value => ID.unwrap(value): java.lang.String))(
        _.assetId
      )
      .optionallyWith(
        propertyId.map(value => ID.unwrap(value): java.lang.String)
      )(_.propertyId)
      .optionallyWith(
        alias.map(value => PropertyAlias.unwrap(value): java.lang.String)
      )(_.alias)
      .timeSeriesId(TimeSeriesId.unwrap(timeSeriesId): java.lang.String)
      .dataType(dataType.unwrap)
      .optionallyWith(
        dataTypeSpec.map(value => Name.unwrap(value): java.lang.String)
      )(_.dataTypeSpec)
      .timeSeriesCreationDate(Timestamp.unwrap(timeSeriesCreationDate): Instant)
      .timeSeriesLastUpdateDate(
        Timestamp.unwrap(timeSeriesLastUpdateDate): Instant
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.DescribeTimeSeriesResponse.ReadOnly =
    zio.aws.iotsitewise.model.DescribeTimeSeriesResponse.wrap(buildAwsValue())
}
object DescribeTimeSeriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeTimeSeriesResponse =
      zio.aws.iotsitewise.model.DescribeTimeSeriesResponse(
        assetId.map(value => value),
        propertyId.map(value => value),
        alias.map(value => value),
        timeSeriesId,
        dataType,
        dataTypeSpec.map(value => value),
        timeSeriesCreationDate,
        timeSeriesLastUpdateDate
      )
    def assetId: Optional[ID]
    def propertyId: Optional[ID]
    def alias: Optional[PropertyAlias]
    def timeSeriesId: TimeSeriesId
    def dataType: zio.aws.iotsitewise.model.PropertyDataType
    def dataTypeSpec: Optional[Name]
    def timeSeriesCreationDate: Timestamp
    def timeSeriesLastUpdateDate: Timestamp
    def getAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetId", assetId)
    def getPropertyId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("propertyId", propertyId)
    def getAlias: ZIO[Any, AwsError, PropertyAlias] =
      AwsError.unwrapOptionField("alias", alias)
    def getTimeSeriesId: ZIO[Any, Nothing, TimeSeriesId] =
      ZIO.succeed(timeSeriesId)
    def getDataType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.PropertyDataType] =
      ZIO.succeed(dataType)
    def getDataTypeSpec: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("dataTypeSpec", dataTypeSpec)
    def getTimeSeriesCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(timeSeriesCreationDate)
    def getTimeSeriesLastUpdateDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(timeSeriesLastUpdateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesResponse
  ) extends zio.aws.iotsitewise.model.DescribeTimeSeriesResponse.ReadOnly {
    override val assetId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.assetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val alias: Optional[PropertyAlias] = zio.aws.core.internal
      .optionalFromNullable(impl.alias())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyAlias(value))
    override val timeSeriesId: TimeSeriesId =
      zio.aws.iotsitewise.model.primitives.TimeSeriesId(impl.timeSeriesId())
    override val dataType: zio.aws.iotsitewise.model.PropertyDataType =
      zio.aws.iotsitewise.model.PropertyDataType.wrap(impl.dataType())
    override val dataTypeSpec: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.dataTypeSpec())
      .map(value => zio.aws.iotsitewise.model.primitives.Name(value))
    override val timeSeriesCreationDate: Timestamp =
      zio.aws.iotsitewise.model.primitives
        .Timestamp(impl.timeSeriesCreationDate())
    override val timeSeriesLastUpdateDate: Timestamp =
      zio.aws.iotsitewise.model.primitives
        .Timestamp(impl.timeSeriesLastUpdateDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesResponse
  ): zio.aws.iotsitewise.model.DescribeTimeSeriesResponse.ReadOnly =
    new Wrapper(impl)
}
