package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ClientToken, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DisassociateAssetsRequest(
    assetId: ID,
    hierarchyId: ID,
    childAssetId: ID,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DisassociateAssetsRequest = {
    import DisassociateAssetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DisassociateAssetsRequest
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .hierarchyId(ID.unwrap(hierarchyId): java.lang.String)
      .childAssetId(ID.unwrap(childAssetId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DisassociateAssetsRequest.ReadOnly =
    zio.aws.iotsitewise.model.DisassociateAssetsRequest.wrap(buildAwsValue())
}
object DisassociateAssetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DisassociateAssetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DisassociateAssetsRequest =
      zio.aws.iotsitewise.model.DisassociateAssetsRequest(
        assetId,
        hierarchyId,
        childAssetId,
        clientToken.map(value => value)
      )
    def assetId: ID
    def hierarchyId: ID
    def childAssetId: ID
    def clientToken: Optional[ClientToken]
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getHierarchyId: ZIO[Any, Nothing, ID] = ZIO.succeed(hierarchyId)
    def getChildAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(childAssetId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DisassociateAssetsRequest
  ) extends zio.aws.iotsitewise.model.DisassociateAssetsRequest.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val hierarchyId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.hierarchyId())
    override val childAssetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.childAssetId())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DisassociateAssetsRequest
  ): zio.aws.iotsitewise.model.DisassociateAssetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
